/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.viewcontroller;

import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.UserPreferencesController;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class FurnitureLibraryUserPreferencesController
extends UserPreferencesController {
    private final FurnitureLibraryUserPreferences preferences;
    private final PropertyChangeSupport propertyChangeSupport;
    private String defaultCreator;
    private boolean offlineFurnitureLibrary;
    private String furnitureResourcesLocalDirectory;
    private String furnitureResourcesRemoteUrlBase;
    private boolean furnitureIdEditable;
    private boolean contentMatchingFurnitureName;

    public FurnitureLibraryUserPreferencesController(FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        super(furnitureLibraryUserPreferences, viewFactory, contentManager);
        this.preferences = furnitureLibraryUserPreferences;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateFurnitureLibraryProperties();
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    private void updateFurnitureLibraryProperties() {
        this.setDefaultCreator(this.preferences.getDefaultCreator());
        this.setFurnitureLibraryOffline(this.preferences.isFurnitureLibraryOffline());
        this.setFurnitureResourcesLocalDirectory(this.preferences.getFurnitureResourcesLocalDirectory());
        this.setFurnitureResourcesRemoteURLBase(this.preferences.getFurnitureResourcesRemoteURLBase());
        this.setFurnitureIdEditable(this.preferences.isFurnitureIdEditable());
        this.setContentMatchingFurnitureName(this.preferences.isContentMatchingFurnitureName());
    }

    public boolean isPropertyEditable(UserPreferencesController.Property property) {
        switch (property) {
            case UNIT: 
            case LANGUAGE: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyEditable(Property property) {
        return this.preferences.isOnlineFurnitureLibrarySupported() || property == Property.DEFAULT_CREATOR || property == Property.FURNITURE_ID_EDITABLE || property == Property.CONTENT_MATCHING_FURNITURE_NAME;
    }

    public String getDefaultCreator() {
        return this.defaultCreator;
    }

    public void setDefaultCreator(String string) {
        if (string != this.defaultCreator || string != null && !string.equals(this.defaultCreator)) {
            String string2 = this.defaultCreator;
            this.defaultCreator = string;
            this.propertyChangeSupport.firePropertyChange(Property.DEFAULT_CREATOR.toString(), string2, string);
        }
    }

    public boolean isFurnitureLibraryOffline() {
        return this.offlineFurnitureLibrary;
    }

    public void setFurnitureLibraryOffline(boolean bl) {
        if (bl != this.offlineFurnitureLibrary) {
            this.offlineFurnitureLibrary = bl;
            this.propertyChangeSupport.firePropertyChange(Property.OFFLINE_FURNITURE_LIBRARY.toString(), !bl, bl);
        }
    }

    public String getFurnitureResourcesLocalDirectory() {
        return this.furnitureResourcesLocalDirectory;
    }

    public void setFurnitureResourcesLocalDirectory(String string) {
        if (string != this.furnitureResourcesLocalDirectory || string != null && !string.equals(this.furnitureResourcesLocalDirectory)) {
            String string2 = this.furnitureResourcesLocalDirectory;
            this.furnitureResourcesLocalDirectory = string;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_RESOURCES_LOCAL_DIRECTORY.toString(), string2, string);
        }
    }

    public String getFurnitureResourcesRemoteURLBase() {
        return this.furnitureResourcesRemoteUrlBase;
    }

    public void setFurnitureResourcesRemoteURLBase(String string) {
        if (string != this.furnitureResourcesRemoteUrlBase || string != null && !string.equals(this.furnitureResourcesRemoteUrlBase)) {
            String string2 = this.furnitureResourcesRemoteUrlBase;
            this.furnitureResourcesRemoteUrlBase = string;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_RESOURCES_REMOTE_URL_BASE.toString(), string2, string);
        }
    }

    public boolean isFurnitureIdEditable() {
        return this.furnitureIdEditable;
    }

    public void setFurnitureIdEditable(boolean bl) {
        if (bl != this.furnitureIdEditable) {
            this.furnitureIdEditable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_ID_EDITABLE.toString(), !bl, bl);
        }
    }

    public boolean isContentMatchingFurnitureName() {
        return this.contentMatchingFurnitureName;
    }

    public void setContentMatchingFurnitureName(boolean bl) {
        if (bl != this.contentMatchingFurnitureName) {
            this.contentMatchingFurnitureName = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CONTENT_MATCHING_FURNITURE_NAME.toString(), !bl, bl);
        }
    }

    public void modifyUserPreferences() {
        super.modifyUserPreferences();
        this.preferences.setDefaultCreator(this.getDefaultCreator());
        if (this.preferences.isOnlineFurnitureLibrarySupported()) {
            this.preferences.setFurnitureLibraryOffline(this.isFurnitureLibraryOffline());
            this.preferences.setFurnitureResourcesLocalDirectory(this.getFurnitureResourcesLocalDirectory());
            this.preferences.setFurnitureResourcesRemoteURLBase(this.getFurnitureResourcesRemoteURLBase());
        }
        this.preferences.setFurnitureIdEditable(this.isFurnitureIdEditable());
        this.preferences.setContentMatchingFurnitureName(this.isContentMatchingFurnitureName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        DEFAULT_CREATOR,
        OFFLINE_FURNITURE_LIBRARY,
        FURNITURE_RESOURCES_LOCAL_DIRECTORY,
        FURNITURE_RESOURCES_REMOTE_URL_BASE,
        FURNITURE_ID_EDITABLE,
        CONTENT_MATCHING_FURNITURE_NAME;

    }
}

