/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.viewcontroller;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryRecorder;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorView;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorViewFactory;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLanguageController;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLibraryController;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLibraryUserPreferencesController;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskController;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.util.concurrent.Callable;

public class EditorController
implements Controller {
    private final FurnitureLibrary furnitureLibrary;
    private final FurnitureLibraryRecorder recorder;
    private final FurnitureLibraryUserPreferences preferences;
    private final ContentManager contentManager;
    private final EditorViewFactory viewFactory;
    private FurnitureLibraryController furnitureLibraryController;
    private FurnitureLanguageController furnitureLanguageController;
    private EditorView editorView;

    public EditorController(FurnitureLibrary furnitureLibrary, FurnitureLibraryRecorder furnitureLibraryRecorder, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, EditorViewFactory editorViewFactory, ContentManager contentManager) {
        this.furnitureLibrary = furnitureLibrary;
        this.recorder = furnitureLibraryRecorder;
        this.preferences = furnitureLibraryUserPreferences;
        this.viewFactory = editorViewFactory;
        this.contentManager = contentManager;
    }

    public EditorView getView() {
        if (this.editorView == null) {
            this.editorView = this.viewFactory.createEditorView(this.furnitureLibrary, this.preferences, this);
        }
        return this.editorView;
    }

    public FurnitureLibraryController getFurnitureLibraryController() {
        if (this.furnitureLibraryController == null) {
            this.furnitureLibraryController = new FurnitureLibraryController(this.furnitureLibrary, this.preferences, this.getFurnitureLanguageController(), this.viewFactory, this.contentManager);
        }
        return this.furnitureLibraryController;
    }

    public FurnitureLanguageController getFurnitureLanguageController() {
        if (this.furnitureLanguageController == null) {
            this.furnitureLanguageController = new FurnitureLanguageController(this.furnitureLibrary, this.preferences, this.viewFactory);
        }
        return this.furnitureLanguageController;
    }

    public void newLibrary() {
        Runnable runnable = new Runnable(){

            public void run() {
                for (CatalogPieceOfFurniture catalogPieceOfFurniture : EditorController.this.furnitureLibrary.getFurniture()) {
                    EditorController.this.furnitureLibrary.deletePieceOfFurniture(catalogPieceOfFurniture);
                }
                EditorController.this.getFurnitureLanguageController().setFurnitureLanguage("");
                EditorController.this.furnitureLibrary.setId(null);
                EditorController.this.furnitureLibrary.setName(null);
                EditorController.this.furnitureLibrary.setProvider(null);
                EditorController.this.furnitureLibrary.setLicense(null);
                EditorController.this.furnitureLibrary.setVersion(null);
                EditorController.this.furnitureLibrary.setDescription(null);
                EditorController.this.furnitureLibrary.setLocation(null);
                EditorController.this.furnitureLibrary.setModified(false);
            }
        };
        if (this.furnitureLibrary.isModified()) {
            switch (this.getView().confirmSave(this.furnitureLibrary.getLocation())) {
                case SAVE: {
                    this.save(runnable);
                }
                case CANCEL: {
                    return;
                }
            }
        }
        runnable.run();
    }

    public void open() {
        Runnable runnable = new Runnable(){

            public void run() {
                String string = EditorController.this.preferences.getLocalizedString(EditorController.class, "openTitle", new Object[0]);
                String string2 = EditorController.this.contentManager.showOpenDialog(null, string, ContentManager.ContentType.FURNITURE_LIBRARY);
                if (string2 != null) {
                    EditorController.this.open(string2);
                }
            }
        };
        if (this.furnitureLibrary.isModified()) {
            switch (this.getView().confirmSave(this.furnitureLibrary.getLocation())) {
                case SAVE: {
                    this.save(runnable);
                }
                case CANCEL: {
                    return;
                }
            }
        }
        runnable.run();
    }

    public void open(final String string) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws RecorderException {
                EditorController.this.recorder.readFurnitureLibrary(EditorController.this.furnitureLibrary, string, EditorController.this.preferences);
                EditorController.this.getFurnitureLanguageController().setFurnitureLanguage("");
                if (!EditorController.this.recorder.isDefaultFurnitureLibrary(string)) {
                    EditorController.this.furnitureLibrary.setLocation(string);
                }
                EditorController.this.furnitureLibrary.setModified(false);
                return null;
            }
        };
        ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

            public void handleException(Exception exception) {
                if (!(exception instanceof InterruptedRecorderException)) {
                    exception.printStackTrace();
                    if (exception instanceof RecorderException) {
                        EditorController.this.getView().showError(EditorController.this.preferences.getLocalizedString(EditorController.class, "errorTitle", new Object[0]), EditorController.this.preferences.getLocalizedString(EditorController.class, "invalidFile", new Object[0]));
                    }
                }
            }
        };
        new ThreadedTaskController(callable, this.preferences.getLocalizedString(EditorController.class, "openMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
    }

    public void merge() {
        String string = this.preferences.getLocalizedString(EditorController.class, "mergeTitle", new Object[0]);
        final String string2 = this.contentManager.showOpenDialog(null, string, ContentManager.ContentType.FURNITURE_LIBRARY);
        if (string2 != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    EditorController.this.recorder.mergeFurnitureLibrary(EditorController.this.furnitureLibrary, string2, EditorController.this.preferences);
                    EditorController.this.furnitureLibrary.setModified(true);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        exception.printStackTrace();
                        if (exception instanceof RecorderException) {
                            EditorController.this.getView().showError(EditorController.this.preferences.getLocalizedString(EditorController.class, "errorTitle", new Object[0]), EditorController.this.preferences.getLocalizedString(EditorController.class, "invalidFile", new Object[0]));
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(EditorController.class, "mergeMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void save() {
        this.save(null);
    }

    private void save(Runnable runnable) {
        if (this.furnitureLibrary.getLocation() == null) {
            this.saveAs(runnable);
        } else {
            this.save(this.furnitureLibrary.getLocation(), runnable);
        }
    }

    public void saveAs() {
        this.saveAs(null);
    }

    private void saveAs(Runnable runnable) {
        String string = this.preferences.getLocalizedString(EditorController.class, "saveTitle", new Object[0]);
        String string2 = this.contentManager.showSaveDialog(null, string, ContentManager.ContentType.FURNITURE_LIBRARY, this.furnitureLibrary.getLocation());
        if (string2 != null) {
            this.save(string2, runnable);
        }
    }

    private void save(final String string, final Runnable runnable) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws RecorderException {
                EditorController.this.recorder.writeFurnitureLibrary(EditorController.this.furnitureLibrary, string, EditorController.this.preferences);
                EditorController.this.getView().invokeLater(new Runnable(){

                    public void run() {
                        EditorController.this.furnitureLibrary.setLocation(string);
                        EditorController.this.furnitureLibrary.setModified(false);
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
                return null;
            }
        };
        ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

            public void handleException(Exception exception) {
                if (!(exception instanceof InterruptedRecorderException)) {
                    exception.printStackTrace();
                    if (exception instanceof RecorderException) {
                        EditorController.this.getView().showError(EditorController.this.preferences.getLocalizedString(EditorController.class, "errorTitle", new Object[0]), EditorController.this.preferences.getLocalizedString(EditorController.class, "saveError", new Object[0]));
                    }
                }
            }
        };
        new ThreadedTaskController(callable, this.preferences.getLocalizedString(EditorController.class, "saveMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
    }

    public void exit() {
        Runnable runnable = new Runnable(){

            public void run() {
                System.exit(0);
            }
        };
        if (this.furnitureLibrary.isModified()) {
            switch (this.getView().confirmSave(this.furnitureLibrary.getLocation())) {
                case SAVE: {
                    this.save(runnable);
                }
                case CANCEL: {
                    return;
                }
            }
        }
        runnable.run();
    }

    public void about() {
        this.getView().showAboutDialog();
    }

    public void editPreferences() {
        try {
            new FurnitureLibraryUserPreferencesController(this.preferences, (ViewFactory)this.viewFactory, this.contentManager).displayView(this.getView());
            this.preferences.write();
        }
        catch (RecorderException recorderException) {
            this.getView().showError(this.preferences.getLocalizedString(EditorController.class, "errorTitle", new Object[0]), this.preferences.getLocalizedString(EditorController.class, "savePreferencesError", new Object[0]));
        }
    }
}

