/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.swing;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorController;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorView;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLibraryController;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ControllerAction;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.swing.UnfocusableToolBar;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class EditorPane
extends JRootPane
implements EditorView {
    private final FurnitureLibraryUserPreferences preferences;

    public EditorPane(FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, EditorController editorController) {
        this.preferences = furnitureLibraryUserPreferences;
        this.createActions(editorController, furnitureLibraryUserPreferences);
        JComponent jComponent = (JComponent)((Object)editorController.getFurnitureLibraryController().getView());
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setTransferHandler(jComponent.getTransferHandler());
        JPopupMenu jPopupMenu = this.createFurnitureLibraryPopupMenu(furnitureLibraryUserPreferences, editorController);
        jComponent.setComponentPopupMenu(jPopupMenu);
        jViewport.setComponentPopupMenu(jPopupMenu);
        this.getContentPane().add(jScrollPane);
        this.getContentPane().add((Component)this.createToolBar(furnitureLibraryUserPreferences, editorController), "North");
        jComponent.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), (Object)EditorView.ActionType.MODIFY_FURNITURE);
        jComponent.getActionMap().put((Object)EditorView.ActionType.MODIFY_FURNITURE, this.getActionMap().get((Object)EditorView.ActionType.MODIFY_FURNITURE));
        editorController.getFurnitureLibraryController().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                EditorPane.this.getActionMap().get((Object)EditorView.ActionType.DELETE).setEnabled(!selectionEvent.getSelectedItems().isEmpty());
                EditorPane.this.getActionMap().get((Object)EditorView.ActionType.MODIFY_FURNITURE).setEnabled(!selectionEvent.getSelectedItems().isEmpty());
            }
        });
    }

    private void createActions(EditorController editorController, UserPreferences userPreferences) {
        ActionMap actionMap = this.getActionMap();
        try {
            actionMap.put((Object)EditorView.ActionType.NEW_LIBRARY, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.NEW_LIBRARY.name(), true, editorController, "newLibrary", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.OPEN, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.OPEN.name(), true, editorController, "open", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.MERGE, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.MERGE.name(), true, editorController, "merge", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.SAVE, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.SAVE.name(), true, editorController, "save", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.SAVE_AS, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.SAVE_AS.name(), true, editorController, "saveAs", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.PREFERENCES, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.PREFERENCES.name(), true, editorController, "editPreferences", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.EXIT, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.EXIT.name(), true, editorController, "exit", new Object[0]));
            FurnitureLibraryController furnitureLibraryController = editorController.getFurnitureLibraryController();
            actionMap.put((Object)EditorView.ActionType.IMPORT_FURNITURE, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.IMPORT_FURNITURE.name(), true, furnitureLibraryController, "importFurniture", new Object[0]));
            boolean bl = furnitureLibraryController.getSelectedFurniture().isEmpty();
            actionMap.put((Object)EditorView.ActionType.MODIFY_FURNITURE, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.MODIFY_FURNITURE.name(), !bl, furnitureLibraryController, "modifySelectedFurniture", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.DELETE, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.DELETE.name(), !bl, furnitureLibraryController, "deleteSelectedFurniture", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.SELECT_ALL, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.SELECT_ALL.name(), true, furnitureLibraryController, "selectAll", new Object[0]));
            actionMap.put((Object)EditorView.ActionType.ABOUT, new ControllerAction(userPreferences, EditorPane.class, EditorView.ActionType.ABOUT.name(), true, editorController, "about", new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException);
        }
    }

    private JToolBar createToolBar(UserPreferences userPreferences, EditorController editorController) {
        UnfocusableToolBar unfocusableToolBar = new UnfocusableToolBar();
        unfocusableToolBar.setFloatable(false);
        this.addActionToToolBar(EditorView.ActionType.NEW_LIBRARY, unfocusableToolBar);
        this.addActionToToolBar(EditorView.ActionType.OPEN, unfocusableToolBar);
        this.addActionToToolBar(EditorView.ActionType.MERGE, unfocusableToolBar);
        this.addActionToToolBar(EditorView.ActionType.SAVE, unfocusableToolBar);
        this.addActionToToolBar(EditorView.ActionType.SAVE_AS, unfocusableToolBar);
        unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
        this.addActionToToolBar(EditorView.ActionType.PREFERENCES, unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        this.addActionToToolBar(EditorView.ActionType.IMPORT_FURNITURE, unfocusableToolBar);
        this.addActionToToolBar(EditorView.ActionType.MODIFY_FURNITURE, unfocusableToolBar);
        this.addActionToToolBar(EditorView.ActionType.DELETE, unfocusableToolBar);
        unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
        JComponent jComponent = (JComponent)((Object)editorController.getFurnitureLanguageController().getView());
        jComponent.setMaximumSize(jComponent.getPreferredSize());
        unfocusableToolBar.add(jComponent);
        unfocusableToolBar.addSeparator();
        this.addActionToToolBar(EditorView.ActionType.ABOUT, unfocusableToolBar);
        return unfocusableToolBar;
    }

    private void addActionToToolBar(EditorView.ActionType actionType, JToolBar jToolBar) {
        ResourceAction.ToolBarAction toolBarAction = new ResourceAction.ToolBarAction(this.getActionMap().get((Object)actionType));
        if (OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
            jToolBar.add(new JButton(new ResourceAction.ToolBarAction(toolBarAction)){

                public Insets getInsets() {
                    Insets insets = super.getInsets();
                    insets.top += 3;
                    insets.bottom += 3;
                    return insets;
                }
            });
        } else {
            jToolBar.add(new JButton(new ResourceAction.ToolBarAction(toolBarAction)));
        }
    }

    private JPopupMenu createFurnitureLibraryPopupMenu(UserPreferences userPreferences, EditorController editorController) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ActionMap actionMap = this.getActionMap();
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.NEW_LIBRARY)));
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.OPEN)));
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.SAVE)));
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.SAVE_AS)));
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.PREFERENCES)));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.IMPORT_FURNITURE)));
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.MODIFY_FURNITURE)));
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.DELETE)));
        jPopupMenu.add(new ResourceAction.MenuItemAction(actionMap.get((Object)EditorView.ActionType.SELECT_ALL)));
        return jPopupMenu;
    }

    public void showError(String string, String string2) {
        JOptionPane.showMessageDialog(SwingUtilities.getRootPane(this), string2, string, 0);
    }

    public HomeView.SaveAnswer confirmSave(String string) {
        String string2 = string != null ? this.preferences.getLocalizedString(EditorPane.class, "confirmSave.message", "\"" + string + "\"") : this.preferences.getLocalizedString(EditorPane.class, "confirmSave.message", "");
        String string3 = this.preferences.getLocalizedString(EditorPane.class, "confirmSave.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(EditorPane.class, "confirmSave.save", new Object[0]);
        String string5 = this.preferences.getLocalizedString(EditorPane.class, "confirmSave.doNotSave", new Object[0]);
        String string6 = this.preferences.getLocalizedString(EditorPane.class, "confirmSave.cancel", new Object[0]);
        switch (JOptionPane.showOptionDialog(SwingUtilities.getRootPane(this), string2, string3, 1, 3, null, new Object[]{string4, string5, string6}, string4)) {
            case 0: {
                return HomeView.SaveAnswer.SAVE;
            }
            case 1: {
                return HomeView.SaveAnswer.DO_NOT_SAVE;
            }
        }
        return HomeView.SaveAnswer.CANCEL;
    }

    public void showAboutDialog() {
        String string = this.preferences.getLocalizedString(EditorPane.class, "about.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(EditorPane.class, "about.version", new Object[0]);
        String string3 = String.format(string, string2, System.getProperty("java.version"));
        JEditorPane jEditorPane = new JEditorPane("text/html", string3);
        jEditorPane.setOpaque(false);
        jEditorPane.setEditable(false);
        if (SwingTools.getResolutionScale() != 1.0f) {
            jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }
        String string4 = this.preferences.getLocalizedString(EditorPane.class, "about.title", new Object[0]);
        ImageIcon imageIcon = new ImageIcon(EditorPane.class.getResource(this.preferences.getLocalizedString(EditorPane.class, "about.icon", new Object[0])));
        JOptionPane.showMessageDialog(SwingUtilities.getRootPane(this), jEditorPane, string4, 1, imageIcon);
    }

    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }
}

