/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.model;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Library;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureLibrary
implements Library {
    public static final String DEFAULT_LANGUAGE = "";
    public static final String FURNITURE_ID_PROPERTY = "ID";
    public static final String FURNITURE_NAME_PROPERTY = "NAME";
    public static final String FURNITURE_DESCRIPTION_PROPERTY = "DESCRIPTION";
    public static final String FURNITURE_INFORMATION_PROPERTY = "INFORMATION";
    public static final String FURNITURE_TAGS_PROPERTY = "TAGS";
    public static final String FURNITURE_CREATION_DATE_PROPERTY = "CREATION_DATE";
    public static final String FURNITURE_GRADE_PROPERTY = "GRADE";
    public static final String FURNITURE_CATEGORY_PROPERTY = "CATEGORY";
    public static final String FURNITURE_CREATOR_PROPERTY = "CREATOR";
    public static final String FURNITURE_PRICE_PROPERTY = "PRICE";
    public static final String FURNITURE_VALUE_ADDED_TAX_PERCENTAGE_PROPERTY = "VALUE_ADDED_TAX_PERCENTAGE";
    public static final String FURNITURE_MODEL_PROPERTY = "MODEL";
    public static final String FURNITURE_ICON_PROPERTY = "ICON";
    public static final String FURNITURE_PLAN_ICON_PROPERTY = "PLAN_ICON";
    public static final String FURNITURE_WIDTH_PROPERTY = "WIDTH";
    public static final String FURNITURE_DEPTH_PROPERTY = "DEPTH";
    public static final String FURNITURE_HEIGHT_PROPERTY = "HEIGHT";
    public static final String FURNITURE_MOVABLE_PROPERTY = "MOVABLE";
    public static final String FURNITURE_DOOR_OR_WINDOW_PROPERTY = "DOOR_OR_WINDOW";
    public static final String FURNITURE_DOOR_OR_WINDOW_CUT_OUT_SHAPE_PROPERTY = "DOOR_OR_WINDOW_CUT_OUT_SHAPE";
    public static final String FURNITURE_STAIRCASE_CUT_OUT_SHAPE_PROPERTY = "STAIRCASE_CUT_OUT_SHAPE";
    public static final String FURNITURE_ELEVATION_PROPERTY = "ELEVATION";
    public static final String FURNITURE_MODEL_ROTATION_PROPERTY = "MODEL_ROTATION";
    public static final String FURNITURE_RESIZABLE_PROPERTY = "RESIZABLE";
    public static final String FURNITURE_DEFORMABLE_PROPERTY = "DEFORMABLE";
    public static final String FURNITURE_TEXTURABLE_PROPERTY = "TEXTURABLE";
    private final PropertyChangeSupport propertyChangeSupport;
    private List<CatalogPieceOfFurniture> furniture = new ArrayList<CatalogPieceOfFurniture>();
    private Map<String, CatalogPieceOfFurniture> furnitureByIds = new HashMap<String, CatalogPieceOfFurniture>();
    private Map<CatalogPieceOfFurniture, Map<String, Map<String, Object>>> furnitureLocalizedData = new IdentityHashMap<CatalogPieceOfFurniture, Map<String, Map<String, Object>>>();
    private Set<String> supportedLanguages = new HashSet<String>();
    private CollectionChangeSupport<CatalogPieceOfFurniture> furnitureChangeSupport;
    private boolean noRequestSinceLastChange = true;
    private String location;
    private boolean modified;
    private String id;
    private String name;
    private String description;
    private String version;
    private String license;
    private String provider;

    public FurnitureLibrary() {
        this.supportedLanguages.add(DEFAULT_LANGUAGE);
        this.furnitureChangeSupport = new CollectionChangeSupport(this);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void addListener(CollectionListener<CatalogPieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeListener(CollectionListener<CatalogPieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.removeCollectionListener(collectionListener);
    }

    public List<CatalogPieceOfFurniture> getFurniture() {
        this.noRequestSinceLastChange = false;
        return Collections.unmodifiableList(this.furniture);
    }

    public void addPieceOfFurniture(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        this.addPieceOfFurniture(catalogPieceOfFurniture, this.furniture.size());
    }

    public void addPieceOfFurniture(CatalogPieceOfFurniture catalogPieceOfFurniture, int n) {
        if (!this.noRequestSinceLastChange) {
            this.furniture = new ArrayList<CatalogPieceOfFurniture>(this.furniture);
            this.noRequestSinceLastChange = true;
        }
        this.furniture.add(n, catalogPieceOfFurniture);
        String string = catalogPieceOfFurniture.getId();
        if (string != null) {
            this.furnitureByIds.put(string, catalogPieceOfFurniture);
        }
        this.furnitureChangeSupport.fireCollectionChanged(catalogPieceOfFurniture, n, CollectionEvent.Type.ADD);
    }

    public void deletePieceOfFurniture(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        for (int i = 0; i < this.furniture.size(); ++i) {
            if (this.furniture.get(i) != catalogPieceOfFurniture) continue;
            if (!this.noRequestSinceLastChange) {
                this.furniture = new ArrayList<CatalogPieceOfFurniture>(this.furniture);
                this.noRequestSinceLastChange = true;
            }
            this.furniture.remove(i);
            String string = catalogPieceOfFurniture.getId();
            if (string != null) {
                this.furnitureByIds.remove(string);
            }
            this.furnitureLocalizedData.remove(catalogPieceOfFurniture);
            if (this.furnitureLocalizedData.isEmpty()) {
                this.supportedLanguages.clear();
                this.supportedLanguages.add(DEFAULT_LANGUAGE);
            }
            this.furnitureChangeSupport.fireCollectionChanged(catalogPieceOfFurniture, i, CollectionEvent.Type.DELETE);
            break;
        }
    }

    public int getPieceOfFurnitureIndex(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        for (int i = 0; i < this.furniture.size(); ++i) {
            if (this.furniture.get(i) != catalogPieceOfFurniture) continue;
            return i;
        }
        return -1;
    }

    public CatalogPieceOfFurniture getPieceOfFurniture(String string) {
        return this.furnitureByIds.get(string);
    }

    public void setPieceOfFurnitureLocalizedData(CatalogPieceOfFurniture catalogPieceOfFurniture, String string, String string2, Object object) {
        Object object2;
        Map<String, Object> map;
        Map<String, Map<String, Object>> map2 = this.furnitureLocalizedData.get(catalogPieceOfFurniture);
        if (map2 == null) {
            map2 = new HashMap<String, Map<String, Object>>();
            this.furnitureLocalizedData.put(catalogPieceOfFurniture, map2);
        }
        if ((map = map2.get(string)) == null) {
            map = new HashMap<String, Object>();
            map2.put(string, map);
            this.supportedLanguages.add(string);
        }
        if ((object2 = map.get(string2)) != object || object != null && !object.equals(object2)) {
            map.put(string2, object);
            this.propertyChangeSupport.firePropertyChange(Property.LOCALIZED_DATA.name(), object2, object);
        }
    }

    public Object getPieceOfFurnitureLocalizedData(CatalogPieceOfFurniture catalogPieceOfFurniture, String string, String string2) {
        return this.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string, string2, null);
    }

    public Object getPieceOfFurnitureLocalizedData(CatalogPieceOfFurniture catalogPieceOfFurniture, String string, String string2, Object object) {
        Object object2;
        Map<String, Object> map;
        Map<String, Map<String, Object>> map2 = this.furnitureLocalizedData.get(catalogPieceOfFurniture);
        if (map2 != null && (map = map2.get(string)) != null && (object2 = map.get(string2)) != null) {
            return object2;
        }
        return object;
    }

    public List<String> getSupportedLanguages() {
        return Collections.unmodifiableList(new ArrayList<String>(this.supportedLanguages));
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        if (string != this.location || string != null && !string.equals(this.location)) {
            String string2 = this.location;
            this.location = string;
            this.propertyChangeSupport.firePropertyChange(Property.LOCATION.name(), string2, string);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        if (bl != this.modified) {
            this.modified = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MODIFIED.toString(), !bl, bl);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        if (string != this.id || string != null && !string.equals(this.id)) {
            String string2 = this.id;
            this.id = string;
            this.propertyChangeSupport.firePropertyChange(Property.ID.name(), string2, string);
        }
    }

    @Override
    public String getType() {
        return "Furniture library";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != this.name || string != null && !string.equals(this.name)) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string != this.description || string != null && !string.equals(this.description)) {
            String string2 = this.description;
            this.description = string;
            this.propertyChangeSupport.firePropertyChange(Property.DESCRIPTION.name(), string2, string);
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        if (string != this.version || string != null && !string.equals(this.version)) {
            String string2 = this.version;
            this.version = string;
            this.propertyChangeSupport.firePropertyChange(Property.VERSION.name(), string2, string);
        }
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    public void setLicense(String string) {
        if (string != this.license || string != null && !string.equals(this.license)) {
            String string2 = this.license;
            this.license = string;
            this.propertyChangeSupport.firePropertyChange(Property.LICENSE.name(), string2, string);
        }
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        if (string != this.provider || string != null && !string.equals(this.provider)) {
            String string2 = this.provider;
            this.provider = string;
            this.propertyChangeSupport.firePropertyChange(Property.PROVIDER.name(), string2, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        LOCATION,
        ID,
        NAME,
        MODIFIED,
        DESCRIPTION,
        VERSION,
        LICENSE,
        PROVIDER,
        LOCALIZED_DATA;

    }
}

