/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.io;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryRecorder;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureLibraryFileRecorder
implements FurnitureLibraryRecorder {
    private static final String DEFAULT_FURNITURE_LIBRARY = "Furniture.jar";
    private static final String[] IGNORED_EXTENSIONS = new String[]{".gsm", ".max", ".lwo", ".dxf"};
    private static final Locale DEFAULT_LOCALE = new Locale("");
    private static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("0.#####", new DecimalFormatSymbols(Locale.US));
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String LICENSE = "license";
    private static final String PROVIDER = "provider";

    @Override
    public void readFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences) throws RecorderException {
        this.readFurnitureLibrary(furnitureLibrary, string, furnitureLibraryUserPreferences, false);
    }

    @Override
    public void mergeFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences) throws RecorderException {
        this.readFurnitureLibrary(furnitureLibrary, string, furnitureLibraryUserPreferences, true);
    }

    @Override
    public boolean isDefaultFurnitureLibrary(String string) {
        return DEFAULT_FURNITURE_LIBRARY.equals(new File(string).getName());
    }

    private void readFurnitureLibrary(final FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, final boolean bl) throws RecorderException {
        try {
            String string2;
            Object object;
            Object object2;
            List<ZipEntry> list;
            Object object3;
            Object object4;
            Locale locale = Locale.getDefault();
            Locale.setDefault(DEFAULT_LOCALE);
            File file = File.createTempFile("furniture", ".sh3f");
            file.deleteOnExit();
            if (this.isDefaultFurnitureLibrary(string)) {
                object4 = DefaultFurnitureCatalog.class.getName().replace('.', '/');
                object3 = new File(string).toURI().toURL();
                list = this.getZipEntries((URL)object3);
                object2 = null;
                try {
                    object2 = new ZipOutputStream(new FileOutputStream(file));
                    ((ZipOutputStream)object2).setLevel(0);
                    for (ZipEntry cloneable22 : list) {
                        object = cloneable22.getName();
                        if (((String)object).startsWith((String)object4) && ((String)object).endsWith(".properties")) {
                            object = ((String)object).replace((CharSequence)object4, "PluginFurnitureCatalog");
                        }
                        this.writeZipEntry((ZipOutputStream)object2, new URLContent(new URL("jar:" + object3 + "!/" + cloneable22.getName())), (String)object);
                    }
                }
                catch (IOException iOException) {
                    throw new RecorderException("Can't copy library file " + string, iOException);
                }
                finally {
                    if (object2 != null) {
                        try {
                            ((ZipOutputStream)object2).close();
                        }
                        catch (IOException iOException) {
                            throw new RecorderException("Can't copy library file " + string, iOException);
                        }
                    }
                }
            }
            this.copyFile(new File(string), file);
            object4 = file.toURI().toURL();
            object3 = furnitureLibraryUserPreferences.getFurnitureResourcesLocalDirectory();
            list = object3 != null ? new File((String)object3).toURI().toURL() : null;
            object2 = new ArrayList();
            new DefaultFurnitureCatalog(new URL[]{object4}, (URL)((Object)list), (List)object2){
                final /* synthetic */ List val$furniture;
                {
                    this.val$furniture = list;
                    super(uRLArray, uRL);
                }

                protected CatalogPieceOfFurniture readPieceOfFurniture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture;
                    if (n == 1 && !bl) {
                        furnitureLibrary.setId(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.ID));
                        furnitureLibrary.setName(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.NAME));
                        furnitureLibrary.setDescription(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.DESCRIPTION));
                        furnitureLibrary.setVersion(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.VERSION));
                        furnitureLibrary.setLicense(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.LICENSE));
                        furnitureLibrary.setProvider(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.PROVIDER));
                    }
                    if ((catalogPieceOfFurniture = super.readPieceOfFurniture(resourceBundle, n, uRL, uRL2)) != null) {
                        FurnitureCategory furnitureCategory = super.readFurnitureCategory(resourceBundle, n);
                        new FurnitureCatalog().add(furnitureCategory, catalogPieceOfFurniture);
                        this.val$furniture.add(catalogPieceOfFurniture);
                    }
                    return catalogPieceOfFurniture;
                }

                private String getOptionalString(ResourceBundle resourceBundle, String string) {
                    try {
                        return resourceBundle.getString(string);
                    }
                    catch (MissingResourceException missingResourceException) {
                        return null;
                    }
                }
            };
            List<ZipEntry> list2 = this.getZipEntries((URL)object4);
            HashSet<Locale> hashSet = new HashSet<Locale>();
            object = list2.iterator();
            while (object.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)object.next();
                string2 = zipEntry.getName();
                if (!string2.startsWith("PluginFurnitureCatalog") || !string2.endsWith(".properties")) continue;
                hashSet.add(this.getLocale(string2));
            }
            if (!bl) {
                for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureLibrary.getFurniture()) {
                    furnitureLibrary.deletePieceOfFurniture(catalogPieceOfFurniture);
                }
            }
            object = object2.iterator();
            while (object.hasNext()) {
                CatalogPieceOfFurniture catalogPieceOfFurniture = object.next();
                furnitureLibrary.addPieceOfFurniture(catalogPieceOfFurniture);
            }
            for (Locale locale2 : hashSet) {
                if ("".equals(locale2.toString())) continue;
                Locale.setDefault(locale2);
                string2 = locale2.toString();
                new DefaultFurnitureCatalog(new URL[]{object4}, (URL)((Object)list), (List)object2, furnitureLibrary, string2){
                    final /* synthetic */ List val$furniture;
                    final /* synthetic */ FurnitureLibrary val$furnitureLibrary;
                    final /* synthetic */ String val$language;
                    {
                        this.val$furniture = list;
                        this.val$furnitureLibrary = furnitureLibrary;
                        this.val$language = string;
                        super(uRLArray, uRL);
                    }

                    protected CatalogPieceOfFurniture readPieceOfFurniture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = super.readPieceOfFurniture(resourceBundle, n, uRL, uRL2);
                        if (catalogPieceOfFurniture != null) {
                            FurnitureCategory furnitureCategory = super.readFurnitureCategory(resourceBundle, n);
                            CatalogPieceOfFurniture catalogPieceOfFurniture2 = (CatalogPieceOfFurniture)this.val$furniture.get(n - 1);
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, "NAME", catalogPieceOfFurniture.getName());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, "DESCRIPTION", catalogPieceOfFurniture.getDescription());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, "INFORMATION", catalogPieceOfFurniture.getInformation());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, "TAGS", catalogPieceOfFurniture.getTags());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, "CATEGORY", furnitureCategory.getName());
                        }
                        return catalogPieceOfFurniture;
                    }
                };
            }
            Locale.setDefault(locale);
        }
        catch (IOException iOException) {
            throw new RecorderException("Invalid furniture library file " + string, iOException);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RecorderException("Invalid furniture library file " + string, missingResourceException);
        }
    }

    private Locale getLocale(String string) {
        String string2 = string.substring("PluginFurnitureCatalog".length(), string.lastIndexOf(".properties"));
        if (string2.matches("_\\w{2}")) {
            return new Locale(string2.substring(1));
        }
        if (string2.matches("_\\w{2}_\\w{2}")) {
            return new Locale(string2.substring(1, 3), string2.substring(4));
        }
        return DEFAULT_LOCALE;
    }

    @Override
    public void writeFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences) throws RecorderException {
        this.writeFurnitureLibrary(furnitureLibrary, string, furnitureLibraryUserPreferences.isFurnitureLibraryOffline(), furnitureLibraryUserPreferences.isContentMatchingFurnitureName(), furnitureLibraryUserPreferences.getFurnitureResourcesLocalDirectory(), furnitureLibraryUserPreferences.getFurnitureResourcesRemoteURLBase());
    }

    private void writeFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, boolean bl, boolean bl2, String string2, String string3) throws RecorderException {
        URL uRL = null;
        String string4 = null;
        if (!bl && string2 != null && string3 != null) {
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                int n = string3.lastIndexOf(47);
                if (n != 1) {
                    string4 = string3.substring(0, n + 1);
                    string2 = new File(string2, string3).toString();
                }
                string4 = "";
            }
        }
        ZipOutputStream zipOutputStream = null;
        HashMap<Content, String> hashMap = new HashMap<Content, String>();
        File file = new File(string);
        File file2 = null;
        try {
            file2 = File.createTempFile("temp", ".sh3f");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            if (fileOutputStream != null) {
                zipOutputStream = new ZipOutputStream(fileOutputStream);
                zipOutputStream.putNextEntry(new ZipEntry("PluginFurnitureCatalog.properties"));
                this.writeFurnitureLibraryProperties(zipOutputStream, furnitureLibrary, file, bl, bl2, uRL, string4, hashMap);
                zipOutputStream.closeEntry();
                for (String string5 : furnitureLibrary.getSupportedLanguages()) {
                    if ("".equals(string5)) continue;
                    zipOutputStream.putNextEntry(new ZipEntry("PluginFurnitureCatalog_" + string5 + ".properties"));
                    this.writeFurnitureLibraryLocalizedProperties(zipOutputStream, furnitureLibrary, string5);
                    zipOutputStream.closeEntry();
                }
                this.writeContents(zipOutputStream, bl, string2, hashMap);
                zipOutputStream.finish();
                zipOutputStream.close();
                zipOutputStream = null;
                this.copyFile(file2, file);
                file2.delete();
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't save furniture library file " + string, iOException);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new RecorderException("Can't close furniture library file " + string, iOException);
                }
            }
        }
    }

    private void writeFurnitureLibraryProperties(OutputStream outputStream, FurnitureLibrary furnitureLibrary, File file, boolean bl, boolean bl2, URL uRL, String string, Map<Content, String> map) throws IOException {
        boolean bl3 = !bl && uRL == null && string == null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashSet<String> hashSet = new HashSet<String>();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
        bufferedWriter.write(String.format("#\n# PluginFurnitureCatalog.properties %tc\n# Generated by Furniture Library Editor\n#\n", new Date()));
        bufferedWriter.newLine();
        this.writeProperty(bufferedWriter, ID, furnitureLibrary.getId());
        this.writeProperty(bufferedWriter, NAME, furnitureLibrary.getName());
        this.writeProperty(bufferedWriter, DESCRIPTION, furnitureLibrary.getDescription());
        this.writeProperty(bufferedWriter, VERSION, furnitureLibrary.getVersion());
        this.writeProperty(bufferedWriter, LICENSE, furnitureLibrary.getLicense());
        this.writeProperty(bufferedWriter, PROVIDER, furnitureLibrary.getProvider());
        int n = 1;
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureLibrary.getFurniture()) {
            int n2;
            String string2;
            String string3;
            String string4;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Long l;
            bufferedWriter.newLine();
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.ID, n, catalogPieceOfFurniture.getId());
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.NAME, n, catalogPieceOfFurniture.getName());
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DESCRIPTION, n, catalogPieceOfFurniture.getDescription());
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.INFORMATION, n, catalogPieceOfFurniture.getInformation());
            String string5 = Arrays.toString(catalogPieceOfFurniture.getTags());
            if (string5.length() > 2) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.TAGS, n, string5.substring(1, string5.length() - 1));
            }
            if ((l = catalogPieceOfFurniture.getCreationDate()) != null) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.CREATION_DATE, n, simpleDateFormat.format(new Date(catalogPieceOfFurniture.getCreationDate())));
            }
            if (catalogPieceOfFurniture.getGrade() != null) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.GRADE, n, catalogPieceOfFurniture.getGrade());
            }
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.CATEGORY, n, catalogPieceOfFurniture.getCategory().getName());
            Content content = catalogPieceOfFurniture.getModel();
            if (bl2 || !(content instanceof URLContent) || ((URLContent)content).getURL().getFile().toString().endsWith("model.obj")) {
                object6 = catalogPieceOfFurniture.getName().replace('/', '-');
            } else {
                object5 = ((URLContent)content).getURL().getFile();
                if (((String)object5).lastIndexOf(47) != -1) {
                    object5 = ((String)object5).substring(((String)object5).lastIndexOf(47) + 1);
                }
                if (((String)object5).lastIndexOf(46) != -1) {
                    object5 = ((String)object5).substring(0, ((String)object5).lastIndexOf(46));
                }
                object6 = object5;
            }
            object6 = ((String)object6).replace('%', '_').replace('#', '_');
            object5 = catalogPieceOfFurniture.getIcon();
            String string6 = map.get(object5);
            if (string6 == null && (string6 = this.getContentEntry((Content)object5, (String)object6 + ".png", bl3, hashSet)) != null) {
                map.put((Content)object5, string6);
            }
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.ICON, n, this.getContentProperty((Content)object5, string6, bl, uRL, string));
            Content content2 = catalogPieceOfFurniture.getPlanIcon();
            if (content2 != null) {
                String string7 = map.get(content2);
                if (string7 == null && (string7 = this.getContentEntry(content2, (String)object6 + "PlanIcon.png", bl3, hashSet)) != null) {
                    map.put(content2, string7);
                }
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.PLAN_ICON, n, this.getContentProperty(content2, string7, bl, uRL, string));
            }
            boolean bl4 = content instanceof ResourceURLContent && ((ResourceURLContent)content).isMultiPartResource() || !(content instanceof ResourceURLContent) && content instanceof URLContent && ((URLContent)content).isJAREntry();
            String string8 = map.get(content);
            if (string8 == null) {
                if (bl4) {
                    object4 = ((URLContent)content).getJAREntryName();
                    string8 = this.getContentEntry(content, content instanceof TemporaryURLContent ? (String)object6 + "/" + (String)object4 : (String)object6 + "/" + ((String)object4).substring(((String)object4).lastIndexOf(47) + 1), bl3, hashSet);
                } else {
                    string8 = this.getContentEntry(content, (String)object6 + ".obj", bl3, hashSet);
                }
                if (string8 != null) {
                    map.put(content, string8);
                }
            }
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.MODEL, n, this.getContentProperty(content, string8, bl, uRL, string));
            if (bl4) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.MULTI_PART_MODEL, n, "true");
            }
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.WIDTH, n, Float.valueOf(catalogPieceOfFurniture.getWidth()));
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DEPTH, n, Float.valueOf(catalogPieceOfFurniture.getDepth()));
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.HEIGHT, n, Float.valueOf(catalogPieceOfFurniture.getHeight()));
            if (Math.abs(catalogPieceOfFurniture.getDropOnTopElevation() - 1.0f) > 1.0E-6f) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DROP_ON_TOP_ELEVATION, n, Float.valueOf(catalogPieceOfFurniture.getDropOnTopElevation() * catalogPieceOfFurniture.getHeight()));
            }
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.MOVABLE, n, catalogPieceOfFurniture.isMovable());
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW, n, catalogPieceOfFurniture.isDoorOrWindow());
            if (catalogPieceOfFurniture.isDoorOrWindow()) {
                object4 = (DoorOrWindow)((Object)catalogPieceOfFurniture);
                if (object4.getCutOutShape() != null) {
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_CUT_OUT_SHAPE, n, object4.getCutOutShape());
                }
                if (object4.getWallThickness() != 1.0f) {
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS, n, Float.valueOf(object4.getWallThickness() * object4.getDepth()));
                }
                if (object4.getWallDistance() != 0.0f) {
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE, n, Float.valueOf(object4.getWallDistance() * object4.getDepth()));
                }
                if (!object4.isWallCutOutOnBothSides()) {
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES, n, object4.isWallCutOutOnBothSides());
                }
                if (!object4.isWidthDepthDeformable()) {
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE, n, object4.isWidthDepthDeformable());
                }
                if (((Serializable[])(object3 = object4.getSashes())).length > 0) {
                    object2 = "";
                    object = "";
                    string4 = "";
                    string3 = "";
                    string2 = "";
                    for (n2 = 0; n2 < ((Serializable[])object3).length; ++n2) {
                        if (n2 > 0) {
                            object2 = (String)object2 + " ";
                            object = (String)object + " ";
                            string4 = string4 + " ";
                            string3 = string3 + " ";
                            string2 = string2 + " ";
                        }
                        object2 = (String)object2 + DECIMAL_FORMAT.format(((Sash)object3[n2]).getXAxis() * object4.getWidth());
                        object = (String)object + DECIMAL_FORMAT.format(((Sash)object3[n2]).getYAxis() * object4.getDepth());
                        string4 = string4 + DECIMAL_FORMAT.format(((Sash)object3[n2]).getWidth() * object4.getWidth());
                        string3 = string3 + Math.round(Math.toDegrees(((Sash)object3[n2]).getStartAngle()) * 100.0) / 100L;
                        string2 = string2 + Math.round(Math.toDegrees(((Sash)object3[n2]).getEndAngle()) * 100.0) / 100L;
                    }
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS, n, object2);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS, n, object);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH, n, string4);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE, n, string3);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE, n, string2);
                }
            }
            if (catalogPieceOfFurniture instanceof Light) {
                object4 = (Light)((Object)catalogPieceOfFurniture);
                object3 = object4.getLightSources();
                if (((LightSource[])object3).length > 0) {
                    object2 = "";
                    object = "";
                    string4 = "";
                    string3 = "";
                    string2 = null;
                    for (n2 = 0; n2 < ((Serializable[])object3).length; ++n2) {
                        if (n2 > 0) {
                            object2 = (String)object2 + " ";
                            object = (String)object + " ";
                            string4 = string4 + " ";
                            string3 = string3 + " ";
                            if (string2 != null) {
                                string2 = string2 + " ";
                            }
                        }
                        object2 = (String)object2 + DECIMAL_FORMAT.format(((LightSource)object3[n2]).getX() * object4.getWidth());
                        object = (String)object + DECIMAL_FORMAT.format(((LightSource)object3[n2]).getY() * object4.getDepth());
                        string4 = string4 + DECIMAL_FORMAT.format(((LightSource)object3[n2]).getZ() * object4.getHeight());
                        string3 = string3 + "#" + String.format("%06X", ((LightSource)object3[n2]).getColor());
                        if (((LightSource)object3[n2]).getDiameter() == null) continue;
                        if (string2 == null) {
                            string2 = "";
                        }
                        string2 = string2 + DECIMAL_FORMAT.format(((LightSource)object3[n2]).getDiameter().floatValue() * object4.getWidth());
                    }
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_X, n, object2);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Y, n, object);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Z, n, string4);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_COLOR, n, string3);
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_DIAMETER, n, string2);
                }
                if (((String[])(object2 = object4.getLightSourceMaterialNames())).length > 0) {
                    this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_MATERIAL_NAME, n, object2);
                }
            }
            if (catalogPieceOfFurniture.getElevation() > 0.0f) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.ELEVATION, n, Float.valueOf(catalogPieceOfFurniture.getElevation()));
            }
            if (!"1 0 0 0 1 0 0 0 1".equals(object3 = this.floatToString((float)(object4 = (Object)catalogPieceOfFurniture.getModelRotation())[0][0]) + " " + this.floatToString((float)object4[0][1]) + " " + this.floatToString((float)object4[0][2]) + " " + this.floatToString((float)object4[1][0]) + " " + this.floatToString((float)object4[1][1]) + " " + this.floatToString((float)object4[1][2]) + " " + this.floatToString((float)object4[2][0]) + " " + this.floatToString((float)object4[2][1]) + " " + this.floatToString((float)object4[2][2]))) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.MODEL_ROTATION, n, object3);
            }
            if (catalogPieceOfFurniture.getModelFlags() != 0) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.MODEL_FLAGS, n, catalogPieceOfFurniture.getModelFlags());
            }
            if (catalogPieceOfFurniture.getStaircaseCutOutShape() != null) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.STAIRCASE_CUT_OUT_SHAPE, n, catalogPieceOfFurniture.getStaircaseCutOutShape());
            }
            if (catalogPieceOfFurniture.getModelSize() != null) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.MODEL_SIZE, n, catalogPieceOfFurniture.getModelSize());
            }
            if (!catalogPieceOfFurniture.isResizable()) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.RESIZABLE, n, catalogPieceOfFurniture.isResizable());
            }
            if (!catalogPieceOfFurniture.isDeformable()) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.DEFORMABLE, n, catalogPieceOfFurniture.isDeformable());
            }
            if (!catalogPieceOfFurniture.isTexturable()) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.TEXTURABLE, n, catalogPieceOfFurniture.isTexturable());
            }
            if (!catalogPieceOfFurniture.isHorizontallyRotatable()) {
                this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.HORIZONTALLY_ROTATABLE, n, catalogPieceOfFurniture.isHorizontallyRotatable());
            }
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.PRICE, n, catalogPieceOfFurniture.getPrice());
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.VALUE_ADDED_TAX_PERCENTAGE, n, catalogPieceOfFurniture.getValueAddedTaxPercentage());
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.CURRENCY, n, catalogPieceOfFurniture.getCurrency());
            object2 = new ArrayList<String>(catalogPieceOfFurniture.getPropertyNames());
            Collections.sort(object2);
            object = object2.iterator();
            while (object.hasNext()) {
                string4 = (String)object.next();
                this.writeProperty(bufferedWriter, string4 + "#" + n, catalogPieceOfFurniture.getProperty(string4));
            }
            this.writeProperty(bufferedWriter, DefaultFurnitureCatalog.PropertyKey.CREATOR, n, catalogPieceOfFurniture.getCreator());
            ++n;
        }
        bufferedWriter.flush();
    }

    private String floatToString(float f) {
        if ((double)Math.abs(f) < 1.0E-6) {
            return "0";
        }
        if ((double)Math.abs(f - 1.0f) < 1.0E-6) {
            return "1";
        }
        if ((double)Math.abs(f + 1.0f) < 1.0E-6) {
            return "-1";
        }
        return String.valueOf(f);
    }

    private void writeFurnitureLibraryLocalizedProperties(OutputStream outputStream, FurnitureLibrary furnitureLibrary, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
        String string2 = "#\n# PluginFurnitureCatalog_" + string + ".properties %tc\n# Generated by Furniture Library Editor\n#\n";
        bufferedWriter.write(String.format(string2, new Date()));
        LinkedHashMap<String, DefaultFurnitureCatalog.PropertyKey> linkedHashMap = new LinkedHashMap<String, DefaultFurnitureCatalog.PropertyKey>();
        linkedHashMap.put("NAME", DefaultFurnitureCatalog.PropertyKey.NAME);
        linkedHashMap.put("DESCRIPTION", DefaultFurnitureCatalog.PropertyKey.DESCRIPTION);
        linkedHashMap.put("INFORMATION", DefaultFurnitureCatalog.PropertyKey.INFORMATION);
        linkedHashMap.put("TAGS", DefaultFurnitureCatalog.PropertyKey.TAGS);
        linkedHashMap.put("CATEGORY", DefaultFurnitureCatalog.PropertyKey.CATEGORY);
        int n = 1;
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureLibrary.getFurniture()) {
            bufferedWriter.newLine();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                Object object = furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string, (String)entry.getKey());
                if (object == null) continue;
                this.writeProperty(bufferedWriter, (DefaultFurnitureCatalog.PropertyKey)((Object)entry.getValue()), n, object);
            }
            ++n;
        }
        bufferedWriter.flush();
    }

    private String getContentEntry(Content content, String string, boolean bl, Set<String> set) throws IOException {
        if (content instanceof TemporaryURLContent || content instanceof ResourceURLContent) {
            int n = string.indexOf(47);
            if (n == -1) {
                if (set.contains(string.toLowerCase())) {
                    int n2;
                    int n3 = 2;
                    String string2 = string;
                    while (set.contains((string = string2.substring(0, n2 = string2.lastIndexOf(46)) + n3++ + string2.substring(n2)).toLowerCase())) {
                    }
                }
            } else {
                String string3 = string.substring(0, n + 1);
                int n4 = 2;
                while (true) {
                    boolean bl2 = false;
                    String string4 = string3.toLowerCase();
                    for (String string5 : set) {
                        if (!string5.startsWith(string4)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) break;
                    string3 = string.substring(0, n) + n4++ + "/";
                }
                string = string3 + string.substring(n + 1);
            }
            set.add(string.toLowerCase());
            return string;
        }
        if (content instanceof URLContent) {
            if (bl) {
                return null;
            }
            URLContent uRLContent = (URLContent)content;
            if (uRLContent.isJAREntry()) {
                String string6 = uRLContent.getJAREntryURL().getFile();
                int n = (string6 = string6.substring(string6.lastIndexOf(47) + 1)).lastIndexOf(".zip");
                if (n == -1) {
                    return null;
                }
                string6 = string6.substring(0, n);
                string = string6 + "/" + uRLContent.getJAREntryName();
            } else {
                String string7 = uRLContent.getURL().getFile();
                string = string7.substring(string7.lastIndexOf(47) + 1);
            }
            set.add(string.toLowerCase());
            return string;
        }
        throw new IOException("Unexpected content class: " + content.getClass().getName());
    }

    private String getContentProperty(Content content, String string, boolean bl, URL uRL, String string2) throws IOException {
        if (bl || uRL == null && string2 == null) {
            return "/" + string;
        }
        if (content instanceof TemporaryURLContent || content instanceof ResourceURLContent || uRL != null || string2 != null) {
            int n = string.indexOf(47);
            if (n == -1) {
                if (uRL != null) {
                    return new URL(uRL, string).toString();
                }
                return string2 + string;
            }
            String string3 = URLEncoder.encode(string.substring(n + 1), "UTF-8").replace("+", "%20").replace("%2F", "/");
            if (uRL != null) {
                return "jar:" + new URL(uRL, string.substring(0, n) + ".zip") + "!/" + string3;
            }
            return string2 + string.substring(0, n) + ".zip!/" + string3;
        }
        return ((URLContent)content).getURL().toString();
    }

    private void writeProperty(BufferedWriter bufferedWriter, DefaultFurnitureCatalog.PropertyKey propertyKey, int n, Object object) throws IOException {
        this.writeProperty(bufferedWriter, propertyKey.getKey(n), object);
    }

    private void writeProperty(BufferedWriter bufferedWriter, String string, Object object) throws IOException {
        if (object != null) {
            String string2;
            bufferedWriter.write(string.replace(":", "\\:").replace("=", "\\=").replace(" ", "\\ "));
            bufferedWriter.write("=");
            if (object.getClass().isArray()) {
                string2 = Arrays.toString((Object[])object);
                string2 = string2.substring(1, string2.length() - 1);
            } else {
                string2 = object instanceof Float ? DECIMAL_FORMAT.format(object) : object.toString();
            }
            CharsetEncoder charsetEncoder = Charset.forName("ISO-8859-1").newEncoder();
            block4: for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                switch (c) {
                    case '\\': {
                        bufferedWriter.write(92);
                        bufferedWriter.write(92);
                        continue block4;
                    }
                    case '\t': {
                        bufferedWriter.write(92);
                        bufferedWriter.write(116);
                        continue block4;
                    }
                    default: {
                        if (charsetEncoder.canEncode(c)) {
                            bufferedWriter.write(c);
                            continue block4;
                        }
                        bufferedWriter.write(92);
                        bufferedWriter.write(117);
                        bufferedWriter.write(Integer.toHexString(c >> 12 & 0xF));
                        bufferedWriter.write(Integer.toHexString(c >> 8 & 0xF));
                        bufferedWriter.write(Integer.toHexString(c >> 4 & 0xF));
                        bufferedWriter.write(Integer.toHexString(c & 0xF));
                    }
                }
            }
            bufferedWriter.newLine();
        }
    }

    private void writeContents(ZipOutputStream zipOutputStream, boolean bl, String string, Map<Content, String> map) throws IOException, InterruptedRecorderException {
        Serializable serializable;
        if (!bl && string != null) {
            serializable = new File(string);
            if (!((File)serializable).exists()) {
                if (!((File)serializable).mkdirs()) {
                    throw new IOException("Can't create directory " + serializable);
                }
            } else if (!((File)serializable).isDirectory()) {
                throw new IOException(serializable + " isn't a directory");
            }
        }
        serializable = new HashMap();
        for (Map.Entry<Content, String> entry : map.entrySet()) {
            Content content = entry.getKey();
            if (content instanceof URLContent) {
                URLContent uRLContent = (URLContent)content;
                String string2 = entry.getValue();
                if (string2.indexOf(47) != -1) {
                    this.writeZipEntries(zipOutputStream, bl, string, uRLContent, string2, (Map<String, List<ZipEntry>>)((Object)serializable));
                } else if (bl || string == null) {
                    this.writeZipEntry(zipOutputStream, uRLContent, string2);
                } else {
                    File file = new File(string, string2);
                    if (!file.exists()) {
                        this.copyContent(uRLContent, file);
                    }
                }
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptedRecorderException();
        }
    }

    private void writeZipEntries(ZipOutputStream zipOutputStream, boolean bl, String string, URLContent uRLContent, String string2, Map<String, List<ZipEntry>> map) throws IOException {
        URL uRL;
        List<ZipEntry> list;
        int n;
        Object object;
        String string3 = string2.substring(0, string2.indexOf(47));
        if (!bl && string != null) {
            object = new File(string, string3 + ".zip");
            if (((File)object).exists()) {
                return;
            }
            zipOutputStream = new ZipOutputStream(new FileOutputStream((File)object));
            string3 = "";
        } else {
            string3 = string3 + "/";
        }
        object = "";
        if (uRLContent instanceof ResourceURLContent && (n = ((String)(object = URLDecoder.decode(uRLContent.getJAREntryName().replace("+", "%2B"), "UTF-8"))).lastIndexOf(47)) != -1) {
            object = ((String)object).substring(0, n + 1);
        }
        if ((list = map.get((uRL = uRLContent.getJAREntryURL()).toString())) == null) {
            list = this.getZipEntries(uRL);
            map.put(uRL.toString(), list);
        }
        for (ZipEntry zipEntry : list) {
            String string4 = zipEntry.getName();
            URLContent uRLContent2 = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
            if (((String)object).length() == 0) {
                boolean bl2 = true;
                for (String string5 : IGNORED_EXTENSIONS) {
                    if (!string4.toLowerCase().endsWith(string5)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                this.writeZipEntry(zipOutputStream, uRLContent2, string3 + string4);
                continue;
            }
            if (!string4.startsWith((String)object)) continue;
            this.writeZipEntry(zipOutputStream, uRLContent2, string3 + string4.substring(((String)object).length()));
        }
        if (!bl && string != null) {
            zipOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZipEntry> getZipEntries(URL uRL) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            Cloneable cloneable;
            ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
            zipInputStream = new ZipInputStream(uRL.openStream());
            while ((cloneable = zipInputStream.getNextEntry()) != null) {
                arrayList.add((ZipEntry)cloneable);
            }
            cloneable = arrayList;
            return cloneable;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntry(ZipOutputStream zipOutputStream, URLContent uRLContent, String string) throws IOException {
        byte[] byArray = new byte[8096];
        InputStream inputStream = null;
        try {
            int n;
            zipOutputStream.putNextEntry(new ZipEntry(string));
            inputStream = uRLContent.openStream();
            while ((n = inputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void copyContent(Content content, File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = content.openStream();
            this.copyContentToFile(inputStream, file);
        }
        catch (IOException iOException) {
            throw new IOException("Can't copy content " + content + " to " + file);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.copyContentToFile(fileInputStream, file2);
        }
        catch (IOException iOException) {
            throw new IOException("Can't copy file " + file + " to " + file2);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyContentToFile(InputStream inputStream, File file) throws IOException {
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't close file " + file);
            }
        }
    }
}

