/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.io;

import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.RecorderException;
import java.io.File;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFurnitureLibraryUserPreferences
extends FurnitureLibraryUserPreferences {
    private static final String LANGUAGE = "language";
    private static final String UNIT = "unit";
    private static final String DEFAULT_CREATOR = "defaultCreator";
    private static final String OFFLINE_FURNITURE_LIBRARY = "offlineFurnitureLibrary";
    private static final String FURNITURE_RESOURCES_LOCAL_DIRECTORY = "furnitureResourcesLocalDirectory";
    private static final String FURNITURE_RESOURCES_REMOTE_URL_BASE = "furnitureResourcesRemoteUrlBase";
    private static final String FURNITURE_ID_EDITABLE = "furnitureIdEditable";
    private static final String CONTENT_MATCHING_FURNITURE_NAME = "contentMatchingFurnitureName";

    public FileFurnitureLibraryUserPreferences() {
        Preferences preferences = this.getPreferences();
        this.setLanguage(preferences.get(LANGUAGE, this.getLanguage()));
        this.setUnit(LengthUnit.valueOf(preferences.get(UNIT, this.getLengthUnit().name())));
        this.setDefaultCreator(preferences.get(DEFAULT_CREATOR, this.getDefaultCreator()));
        boolean bl = preferences.getBoolean(OFFLINE_FURNITURE_LIBRARY, this.isFurnitureLibraryOffline());
        if (this.isOnlineFurnitureLibrarySupported()) {
            this.setFurnitureLibraryOffline(bl);
            this.setFurnitureResourcesLocalDirectory(preferences.get(FURNITURE_RESOURCES_LOCAL_DIRECTORY, this.getFurnitureResourcesLocalDirectory()));
            this.setFurnitureResourcesRemoteURLBase(preferences.get(FURNITURE_RESOURCES_REMOTE_URL_BASE, this.getFurnitureResourcesRemoteURLBase()));
        }
        this.setFurnitureIdEditable(preferences.getBoolean(FURNITURE_ID_EDITABLE, this.isFurnitureIdEditable()));
        this.setContentMatchingFurnitureName(preferences.getBoolean(CONTENT_MATCHING_FURNITURE_NAME, this.isContentMatchingFurnitureName()));
    }

    @Override
    public void write() throws RecorderException {
        Preferences preferences = this.getPreferences();
        preferences.put(LANGUAGE, this.getLanguage());
        preferences.put(UNIT, this.getLengthUnit().name());
        if (this.getDefaultCreator() != null) {
            preferences.put(DEFAULT_CREATOR, this.getDefaultCreator());
        } else {
            preferences.remove(DEFAULT_CREATOR);
        }
        preferences.putBoolean(OFFLINE_FURNITURE_LIBRARY, this.isFurnitureLibraryOffline());
        if (this.getFurnitureResourcesLocalDirectory() != null) {
            preferences.put(FURNITURE_RESOURCES_LOCAL_DIRECTORY, this.getFurnitureResourcesLocalDirectory());
        } else {
            preferences.remove(FURNITURE_RESOURCES_LOCAL_DIRECTORY);
        }
        if (this.getFurnitureResourcesRemoteURLBase() != null) {
            preferences.put(FURNITURE_RESOURCES_REMOTE_URL_BASE, this.getFurnitureResourcesRemoteURLBase());
        } else {
            preferences.remove(FURNITURE_RESOURCES_REMOTE_URL_BASE);
        }
        preferences.putBoolean(FURNITURE_ID_EDITABLE, this.isFurnitureIdEditable());
        preferences.putBoolean(CONTENT_MATCHING_FURNITURE_NAME, this.isContentMatchingFurnitureName());
        try {
            preferences.sync();
        }
        catch (BackingStoreException backingStoreException) {
            throw new RecorderException("Couldn't write preferences", backingStoreException);
        }
    }

    protected Preferences getPreferences() {
        return Preferences.userNodeForPackage(FileFurnitureLibraryUserPreferences.class);
    }

    @Override
    public void addFurnitureLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLanguageLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTexturesLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean furnitureLibraryExists(String string) throws RecorderException {
        return new File(string).exists();
    }

    @Override
    public boolean languageLibraryExists(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean texturesLibraryExists(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Library> getLibraries() {
        throw new UnsupportedOperationException();
    }
}

