/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.imageio;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import org.sejda.core.writer.imageio.AbstractImageWriter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.PdfToImageParameters;

abstract class MultiImageWriter<T extends PdfToImageParameters>
extends AbstractImageWriter<T> {
    private boolean prepared = false;
    private ImageWriteParam imageWriterParams;

    MultiImageWriter(String format) {
        super(format);
        if (!this.writer.canWriteSequence()) {
            throw new UnsupportedOperationException("The ImageWriter does not support writing multiple images to a single image file.");
        }
    }

    @Override
    public void openDestination(File file, T params) throws TaskIOException {
        super.openDestination(file, params);
        this.imageWriterParams = this.newImageWriterParams(params);
    }

    @Override
    public void write(RenderedImage image, T params) throws TaskIOException {
        TaskIOException.require((boolean)Objects.nonNull(this.getOutput()), (String)"Cannot call write before opening the write destination");
        try {
            if (!this.prepared) {
                this.writer.prepareWriteSequence(null);
                this.prepared = true;
            }
            this.writer.writeToSequence(new IIOImage(image, null, this.newImageMetadata(image, params, this.imageWriterParams)), this.imageWriterParams);
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    @Override
    public void closeDestination() throws TaskIOException {
        if (Objects.nonNull(this.writer)) {
            try {
                this.writer.endWriteSequence();
            }
            catch (IOException e) {
                throw new TaskIOException("An error occurred while ending write sequence", (Throwable)e);
            }
        }
        super.closeDestination();
    }

    @Override
    public boolean supportMultiImage() {
        return true;
    }
}

