/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.support.params;

import java.util.Arrays;
import javafx.scene.paint.Color;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.I18nContext;
import org.sejda.commons.collection.NullSafeSet;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PagesSelection;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    public static NullSafeSet<PageRange> toPageRangeSet(String selection) throws ConversionException {
        if (StringUtils.isNotBlank((CharSequence)selection)) {
            NullSafeSet pageRangeSet = new NullSafeSet();
            Arrays.stream(StringUtils.split((String)selection, (String)",")).map(StringUtils::strip).map(ConversionUtils::toPageRange).forEachOrdered(arg_0 -> ((NullSafeSet)pageRangeSet).add(arg_0));
            return pageRangeSet;
        }
        return new NullSafeSet();
    }

    public static NullSafeSet<PagesSelection> toPagesSelectionSet(String selection) throws ConversionException {
        if (StringUtils.isNotBlank((CharSequence)selection)) {
            NullSafeSet pageRangeSet = new NullSafeSet();
            Arrays.stream(StringUtils.split((String)selection, (String)",")).map(StringUtils::strip).map(ConversionUtils::toPageSelection).forEachOrdered(arg_0 -> ((NullSafeSet)pageRangeSet).add(arg_0));
            return pageRangeSet;
        }
        return new NullSafeSet();
    }

    private static PageRange toPageRange(String value) throws ConversionException {
        String[] limits = AdapterUtils.splitAndTrim((String)value, (String)"-");
        if (limits.length > 2) {
            throw new ConversionException(I18nContext.i18n().tr("Ambiguous page range definition: {0}. Use following formats: [n] or [n1-n2] or [-n] or [n-]", new String[]{value}));
        }
        if (limits.length == 1) {
            int limitNumber = ConversionUtils.parsePageNumber(limits[0]);
            if (value.endsWith("-")) {
                return new PageRange(limitNumber);
            }
            if (value.startsWith("-")) {
                return new PageRange(1, limitNumber);
            }
            return PageRange.one((int)limitNumber);
        }
        PageRange range = new PageRange(ConversionUtils.parsePageNumber(limits[0]), ConversionUtils.parsePageNumber(limits[1]));
        if (range.getEnd() < range.getStart()) {
            throw new ConversionException(I18nContext.i18n().tr("Invalid range: {0}.", new String[]{range.toString()}));
        }
        return range;
    }

    private static int parsePageNumber(String value) throws ConversionException {
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ConversionException(I18nContext.i18n().tr("Invalid number: {0}.", new String[]{value}));
        }
    }

    private static PagesSelection toPageSelection(String value) {
        if ("last".equals(value)) {
            return PagesSelection.LAST_PAGE;
        }
        return ConversionUtils.toPageRange(value);
    }

    public static String toWeb(Color color) {
        int r = (int)Math.round(color.getRed() * 255.0);
        int g = (int)Math.round(color.getGreen() * 255.0);
        int b = (int)Math.round(color.getBlue() * 255.0);
        int o = (int)Math.round(color.getOpacity() * 255.0);
        return String.format("#%02x%02x%02x%02x", r, g, b, o);
    }
}

