/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.support.io;

import java.io.BufferedWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import javafx.scene.input.ClipboardContent;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.io.OngoingWrite;
import org.pdfsam.i18n.I18nContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectCollectionWriter
implements OngoingWrite {
    public static final String SEPARATOR = System.getProperty("line.separator", "\n");
    private static final Logger LOG = LoggerFactory.getLogger(ObjectCollectionWriter.class);
    private final Collection<?> content;

    private ObjectCollectionWriter(Collection<?> content) {
        this.content = content;
    }

    public static OngoingWrite writeContent(Collection<?> content) {
        return new ObjectCollectionWriter(content);
    }

    @Override
    public void to(Path file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (Object item : this.content) {
                writer.append(this.defaultLineSeparator(item.toString()));
            }
        }
        catch (Exception e) {
            LOG.error(I18nContext.i18n().tr("Error saving content to file {0}", new String[]{Optional.ofNullable(file).map(Path::toString).orElse("")}), (Throwable)e);
        }
        LOG.info(I18nContext.i18n().tr("File {0} saved", new String[]{file.toString()}));
    }

    @Override
    public void to(ClipboardContent clipboard) {
        try (StringWriter writer = new StringWriter();){
            for (Object item : this.content) {
                writer.append(this.defaultLineSeparator(item.toString()));
            }
            clipboard.putString(writer.toString());
        }
        catch (Exception e) {
            LOG.error(I18nContext.i18n().tr("Error saving content to clipboard"), (Throwable)e);
        }
    }

    private String defaultLineSeparator(String line) {
        return StringUtils.trimToEmpty((String)line).concat(SEPARATOR);
    }
}

