/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.context;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.core.context.IntegerPersistentProperty;
import org.pdfsam.core.context.PersistentProperty;
import org.pdfsam.core.context.PersistentPropertyChange;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.persistence.PersistenceException;
import org.pdfsam.persistence.PreferencesRepository;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationPersistentSettings {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationPersistentSettings.class);
    private final PreferencesRepository repo;
    private final SimpleObjectProperty<PersistentPropertyChange<String>> stringSettingsChanges = new SimpleObjectProperty();
    private final SimpleObjectProperty<PersistentPropertyChange<Integer>> intSettingsChanges = new SimpleObjectProperty();
    private final SimpleObjectProperty<PersistentPropertyChange<Boolean>> boolSettingsChanges = new SimpleObjectProperty();

    ApplicationPersistentSettings(PreferencesRepository repo) {
        this.repo = repo;
    }

    public Optional<String> get(StringPersistentProperty prop) {
        RequireUtils.requireNotNullArg((Object)prop, (String)"Cannot get value for a null property");
        try {
            return Optional.ofNullable(this.repo.getString(prop.key(), prop.defaultSupplier()));
        }
        catch (PersistenceException e) {
            LOG.error("Unable to get persistent property: " + String.valueOf(prop), (Throwable)e);
            return Optional.ofNullable(prop.defaultSupplier().get());
        }
    }

    public int get(IntegerPersistentProperty prop) {
        RequireUtils.requireNotNullArg((Object)prop, (String)"Cannot get value for a null property");
        try {
            return this.repo.getInt(prop.key(), prop.defaultSupplier());
        }
        catch (PersistenceException e) {
            LOG.error("Unable to get persistent property: " + String.valueOf(prop), (Throwable)e);
            return prop.defaultSupplier().get();
        }
    }

    public boolean get(BooleanPersistentProperty prop) {
        RequireUtils.requireNotNullArg((Object)prop, (String)"Cannot get value for a null property");
        try {
            return this.repo.getBoolean(prop.key(), prop.defaultSupplier());
        }
        catch (NumberFormatException | PersistenceException e) {
            LOG.error("Unable to get persistent property: " + String.valueOf(prop), e);
            return prop.defaultSupplier().get();
        }
    }

    public void set(StringPersistentProperty prop, String value) {
        RequireUtils.requireNotNullArg((Object)prop, (String)"Cannot set value for a null property");
        try {
            this.repo.saveString(prop.key(), value);
            this.stringSettingsChanges.set(new PersistentPropertyChange<String>(prop, Optional.ofNullable(value)));
        }
        catch (PersistenceException e) {
            LOG.error("Unable to save persistent property", (Throwable)e);
        }
    }

    public void set(IntegerPersistentProperty prop, int value) {
        RequireUtils.requireNotNullArg((Object)prop, (String)"Cannot set value for a null property");
        try {
            this.repo.saveInt(prop.key(), value);
            this.intSettingsChanges.set(new PersistentPropertyChange<Integer>(prop, Optional.of(value)));
        }
        catch (PersistenceException e) {
            LOG.error("Unable to save persistent property", (Throwable)e);
        }
    }

    public void set(BooleanPersistentProperty prop, boolean value) {
        RequireUtils.requireNotNullArg((Object)prop, (String)"Cannot set value for a null property");
        try {
            this.repo.saveBoolean(prop.key(), value);
            this.boolSettingsChanges.set(new PersistentPropertyChange<Boolean>(prop, Optional.of(value)));
        }
        catch (PersistenceException e) {
            LOG.error("Unable to save persistent property", (Throwable)e);
        }
    }

    public boolean hasValueFor(PersistentProperty<?> property) {
        if (Objects.nonNull(property)) {
            return Arrays.stream(this.repo.keys()).anyMatch(k -> k.equals(property.key()));
        }
        return false;
    }

    public void delete(PersistentProperty<?> property) {
        if (Objects.nonNull(property)) {
            this.repo.delete(property.key());
        }
    }

    public ObservableValue<Optional<String>> settingsChanges(StringPersistentProperty prop) {
        SimpleObjectProperty value = new SimpleObjectProperty(Optional.empty());
        this.stringSettingsChanges.subscribe((old, c) -> {
            if (c.property().equals(prop)) {
                value.set(c.value());
            }
        });
        return value;
    }

    public ObservableValue<Optional<Integer>> settingsChanges(IntegerPersistentProperty prop) {
        SimpleObjectProperty value = new SimpleObjectProperty(Optional.empty());
        this.intSettingsChanges.subscribe((old, c) -> {
            if (c.property().equals(prop)) {
                value.set(c.value());
            }
        });
        return value;
    }

    public ObservableValue<Optional<Boolean>> settingsChanges(BooleanPersistentProperty prop) {
        SimpleObjectProperty value = new SimpleObjectProperty(Optional.empty());
        this.boolSettingsChanges.subscribe((old, c) -> {
            if (c.property().equals(prop)) {
                value.set(c.value());
            }
        });
        return value;
    }

    public void clean() {
        try {
            this.repo.clean();
            LOG.info("Persistent application settings deleted");
        }
        catch (PersistenceException e) {
            LOG.error("Unable to clear application settings", (Throwable)e);
        }
    }
}

