/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.context;

import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.context.ApplicationPersistentSettings;
import org.pdfsam.core.context.ApplicationRuntimeState;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.core.support.params.ConversionUtils;
import org.pdfsam.injector.Injector;
import org.pdfsam.injector.Key;
import org.pdfsam.persistence.PreferencesRepository;

public class ApplicationContext
implements Closeable {
    private static final ApplicationContext CONTEXT = new ApplicationContext();
    private final ApplicationPersistentSettings persistentSettings;
    private ApplicationRuntimeState runtimeState;
    private Optional<Injector> injector = Optional.empty();

    private ApplicationContext() {
        this(new ApplicationPersistentSettings(new PreferencesRepository("/org/pdfsam/user/conf")), null);
    }

    @Deprecated
    ApplicationContext(ApplicationPersistentSettings persistentSettings, ApplicationRuntimeState runtimeState) {
        this.persistentSettings = persistentSettings;
        this.runtimeState = runtimeState;
    }

    public static ApplicationContext app() {
        return CONTEXT;
    }

    public ApplicationPersistentSettings persistentSettings() {
        return this.persistentSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationRuntimeState runtimeState() {
        ApplicationContext applicationContext = this;
        synchronized (applicationContext) {
            if (Objects.isNull(this.runtimeState)) {
                this.runtimeState = new ApplicationRuntimeState();
                this.persistentSettings().settingsChanges(StringPersistentProperty.WORKING_PATH).subscribe(path -> this.runtimeState.defaultWorkingPath(path.filter(StringUtils::isNotBlank).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).orElse(null)));
                Path workingPath = this.persistentSettings().get(StringPersistentProperty.WORKING_PATH).filter(StringUtils::isNotBlank).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).orElse(null);
                this.runtimeState.defaultWorkingPath(workingPath);
            }
        }
        return this.runtimeState;
    }

    public void registerScene(Scene scene) {
        this.runtimeState().theme().subscribe(t -> {
            if (Objects.nonNull(t)) {
                Platform.runLater(() -> {
                    scene.getStylesheets().setAll((Collection)t.stylesheets());
                    if (!Platform.isSupported((ConditionalFeature)ConditionalFeature.TRANSPARENT_WINDOW)) {
                        scene.getStylesheets().addAll((Collection)t.transparentIncapableStylesheets());
                    }
                    Optional.ofNullable(t.defaultPrimary()).or(() -> Optional.of(ConversionUtils.toWeb(Platform.getPreferences().getAccentColor()))).map(c -> String.format(".root{-default-primary: %s;}", c)).map(css -> "data:text/css;base64," + Base64.getEncoder().encodeToString(css.getBytes())).ifPresent(arg_0 -> scene.getStylesheets().add(arg_0));
                    this.persistentSettings().get(StringPersistentProperty.FONT_SIZE).filter(Predicate.not(String::isBlank)).ifPresent(size -> scene.getRoot().setStyle(String.format("-fx-font-size: %s;", size)));
                });
            }
        });
        this.persistentSettings().settingsChanges(StringPersistentProperty.FONT_SIZE).subscribe(size -> size.filter(StringUtils::isNotBlank).map(s -> String.format("-fx-font-size: %s;", s)).ifPresentOrElse(arg_0 -> ((Parent)scene.getRoot()).setStyle(arg_0), () -> scene.getRoot().setStyle("")));
    }

    public void injector(Injector injector) {
        this.injector = Optional.ofNullable(injector);
    }

    public <T> T instance(Class<T> type) {
        return (T)this.injector.orElseThrow(() -> new IllegalStateException("Injector not set for this application")).instance(type);
    }

    public <T> T instance(Key<T> key) {
        return (T)this.injector.orElseThrow(() -> new IllegalStateException("Injector not set for this application")).instance(key);
    }

    public void clean() {
        this.persistentSettings.clean();
    }

    @Override
    public void close() {
        this.injector.ifPresent(Injector::close);
    }
}

