/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.sejda.commons.util.IOUtils;
import org.sejda.io.SeekableSource;

public class ThreadBoundCopiesSupplier<T extends SeekableSource>
implements Closeable,
Supplier<T> {
    private final ConcurrentMap<Long, T> copies = new ConcurrentHashMap<Long, T>();
    private final Supplier<T> supplier;

    public ThreadBoundCopiesSupplier(Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    @Override
    public T get() {
        return (T)this.copies.computeIfAbsent(Thread.currentThread().threadId(), k -> (SeekableSource)this.supplier.get());
    }

    @Override
    public void close() {
        this.copies.values().forEach(IOUtils::closeQuietly);
        this.copies.clear();
    }
}

