/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.BaseSeekableSource;
import org.sejda.io.SeekableSource;

class SeekableSourceView
extends BaseSeekableSource {
    private final long startingPosition;
    private final long length;
    private long currentPosition;
    private final Supplier<? extends SeekableSource> supplier;

    public SeekableSourceView(Supplier<? extends SeekableSource> supplier, String id, long startingPosition, long length) {
        super(id);
        RequireUtils.requireArg((startingPosition >= 0L ? 1 : 0) != 0, (String)"Starting position cannot be negative");
        RequireUtils.requireArg((length > 0L ? 1 : 0) != 0, (String)"View length must be positive");
        RequireUtils.requireNotNullArg(supplier, (String)"Input decorated SeekableSource cannot be null");
        this.startingPosition = startingPosition;
        this.currentPosition = 0L;
        SeekableSource wrapped = supplier.get();
        RequireUtils.requireArg((startingPosition < wrapped.size() ? 1 : 0) != 0, (String)"Starting position cannot be higher then wrapped source size");
        this.length = Math.min(length, wrapped.size() - startingPosition);
        this.supplier = supplier;
    }

    @Override
    public long position() {
        return this.currentPosition;
    }

    @Override
    public SeekableSource position(long newPosition) throws IOException {
        SeekableSource wrapped = this.supplier.get();
        RequireUtils.requireArg((newPosition >= 0L ? 1 : 0) != 0, (String)"Cannot set position to a negative value");
        this.currentPosition = Math.min(this.length, newPosition);
        wrapped.position(this.startingPosition + this.currentPosition);
        return this;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        SeekableSource wrapped = this.supplier.get();
        this.requireOpen();
        if (this.hasAvailable()) {
            int read;
            wrapped.position(this.startingPosition + this.currentPosition);
            if ((long)dst.remaining() > this.available()) {
                dst.limit(dst.position() + (int)this.available());
            }
            if ((read = wrapped.read(dst)) > 0) {
                this.currentPosition += (long)read;
                return read;
            }
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        this.requireOpen();
        SeekableSource wrapped = this.supplier.get();
        if (this.hasAvailable()) {
            wrapped.position(this.startingPosition + this.currentPosition);
            ++this.currentPosition;
            return wrapped.read();
        }
        return -1;
    }

    private boolean hasAvailable() {
        return this.available() > 0L;
    }

    private long available() {
        return this.length - this.currentPosition;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.currentPosition = 0L;
    }

    @Override
    public void requireOpen() throws IOException {
        super.requireOpen();
        SeekableSource wrapped = this.supplier.get();
        RequireUtils.requireState((boolean)wrapped.isOpen(), (String)"The original SeekableSource has been closed");
    }

    @Override
    public SeekableSource view(long startingPosition, long length) {
        throw new RuntimeException("Cannot create a view of a view");
    }
}

