/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.split;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.core.support.params.SinglePdfSourceMultipleOutputParametersBuilder;
import org.pdfsam.core.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.tools.split.SplitOptionsPane;
import org.pdfsam.ui.components.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.prefix.PrefixPane;
import org.pdfsam.ui.components.selection.single.TaskParametersBuilderSingleSelectionPane;
import org.pdfsam.ui.components.support.Views;
import org.pdfsam.ui.components.tool.BaseToolPanel;
import org.pdfsam.ui.components.tool.Footer;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.prefix.Prefix;

public class SplitToolPanel
extends BaseToolPanel {
    private final TaskParametersBuilderSingleSelectionPane selectionPane;
    private final BrowsableOutputDirectoryField destinationDirectoryField;
    private final PdfDestinationPane destinationPane;
    private final SplitOptionsPane splitOptions = new SplitOptionsPane();
    private final PrefixPane prefix;

    @Inject
    public SplitToolPanel(@Named(value="split.simplefield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="split.simplepane") PdfDestinationPane destinationPane, @Named(value="split.simplefooter") Footer footer, @Named(value="split.simpleprefix") PrefixPane prefix) {
        super("split.simple", footer);
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.selectionPane = new TaskParametersBuilderSingleSelectionPane(this.id());
        this.selectionPane.setPromptText(I18nContext.i18n().tr("Select or drag and drop the PDF you want to split"));
        this.selectionPane.addOnLoaded(d -> this.splitOptions.setMaxPages((Integer)d.pages().getValue()));
        this.prefix = prefix;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.splitOptions.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.splitOptions.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    protected Builder<? extends AbstractSplitByPageParameters> getBuilder(Consumer<String> onError) {
        Optional<SinglePdfSourceMultipleOutputParametersBuilder<? extends AbstractSplitByPageParameters>> builder = Optional.ofNullable(this.splitOptions.getBuilder(onError));
        builder.ifPresent(b -> {
            this.selectionPane.apply((SinglePdfSourceTaskParametersBuilder)b, onError);
            this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder)b, onError);
            this.destinationPane.apply((AbstractPdfOutputParametersBuilder)b, onError);
            this.prefix.apply((MultipleOutputTaskParametersBuilder)b, onError);
        });
        return builder.orElse(null);
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        TitledPane prefixTitled = Views.titledPane((String)I18nContext.i18n().tr("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.CURRENTPAGE});
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.FILENUMBER});
        this.prefix.addMenuItemFor(new String[]{"[TOTAL_FILESNUMBER]"});
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)I18nContext.i18n().tr("Split settings"), (Node)this.splitOptions), Views.titledPane((String)I18nContext.i18n().tr("Output settings"), (Node)this.destinationPane), prefixTitled});
        return pane;
    }

    @EventListener
    public void onClearModule(ClearToolRequest e) {
        if (e.clearEverything()) {
            this.splitOptions.resetView();
            this.prefix.resetView();
            this.destinationPane.resetView();
        }
    }

    @EventStation
    public String id() {
        return "split.simple";
    }
}

