/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.split;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.RadioButton;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.SplitParametersBuilder;
import org.pdfsam.core.support.validation.Validators;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.split.SplitParametersBuilderCreator;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.sejda.conversion.PageNumbersListAdapter;
import org.sejda.model.input.PdfSource;
import org.sejda.model.parameter.SplitByPagesParameters;

class SplitAfterRadioButton
extends RadioButton
implements SplitParametersBuilderCreator,
RestorableView,
ResettableView {
    private final ValidableTextField field;

    public SplitAfterRadioButton(ValidableTextField field) {
        super(I18nContext.i18n().tr("Split after the following page numbers"));
        this.field = field;
        this.field.setOnEnterValidation(true);
        this.field.setEnableInvalidStyle(true);
        this.field.setPromptText(I18nContext.i18n().tr("Page numbers to split at (n1,n2,n3..)"));
        this.field.setValidator(Validators.regexMatching((String)"^([1-9]\\d*(\\s*,\\s*)?)+$"));
        this.field.setErrorMessage(I18nContext.i18n().tr("Invalid page numbers"));
    }

    public SplitByPageParametersBuilder getBuilder(Consumer<String> onError) {
        this.field.validate();
        if (this.field.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            return new SplitByPageParametersBuilder(new PageNumbersListAdapter(this.field.getText()).getPageNumbers());
        }
        onError.accept(I18nContext.i18n().tr("Only valid positive page numbers are allowed"));
        return null;
    }

    public void saveStateTo(Map<String, String> data) {
        if (this.isSelected()) {
            data.put("splitAfter", Boolean.TRUE.toString());
        }
        data.put("splitAfter.field", StringUtils.defaultString((String)this.field.getText()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("splitAfter")).map(Boolean::valueOf).ifPresent(arg_0 -> ((SplitAfterRadioButton)this).setSelected(arg_0));
        this.field.setText(Optional.ofNullable(data.get("splitAfter.field")).orElse(""));
    }

    public void resetView() {
        this.field.clear();
    }

    static class SplitByPageParametersBuilder
    extends SplitParametersBuilder<SplitByPagesParameters> {
        private final List<Integer> pages;

        SplitByPageParametersBuilder(List<Integer> pages) {
            this.pages = pages;
        }

        public SplitByPagesParameters build() {
            SplitByPagesParameters params = new SplitByPagesParameters();
            params.addPages(this.pages);
            params.setCompress(this.isCompress());
            params.setExistingOutputPolicy(this.existingOutput());
            params.setVersion(this.getVersion());
            params.setOutput(this.getOutput());
            params.setOutputPrefix(this.getPrefix());
            params.addSource((PdfSource)this.getSource());
            params.setOptimizationPolicy(this.getOptimizationPolicy());
            params.discardOutline(this.isDiscardBookmarks());
            return params;
        }
    }
}

