/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.persistence;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.pdfsam.persistence.PersistenceException;
import org.pdfsam.persistence.Repository;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesRepository
implements Repository {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesRepository.class);
    final String path;

    public PreferencesRepository(String path) {
        RequireUtils.requireNotBlank((String)path, (String)"Preferences path cannot be blank");
        this.path = path;
    }

    @Override
    public int getInt(String key, int defaultValue) {
        try {
            return Preferences.userRoot().node(this.path).getInt(key, defaultValue);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to get value: [key '%s']", key), e);
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        try {
            return Preferences.userRoot().node(this.path).getLong(key, defaultValue);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to get value: [key '%s']", key), e);
        }
    }

    @Override
    public String getString(String key, Supplier<String> supplier) {
        RequireUtils.requireNotBlank((String)key, (String)"Key cannot be blank");
        try {
            return Optional.ofNullable(Preferences.userRoot().node(this.path).get(key, null)).orElseGet(supplier);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to get value: [key '%s']", key), e);
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Preferences.userRoot().node(this.path).getBoolean(key, defaultValue);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to get value: [key '%s']", key), e);
        }
    }

    @Override
    public void saveInt(String key, int value) {
        RequireUtils.requireNotBlank((String)key, (String)"Key cannot be blank");
        try {
            Preferences.userRoot().node(this.path).putInt(key, value);
            LOG.trace("Saved entity [key '{}', value '{}']", (Object)key, (Object)value);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to store value: [key '%s', value '%s']", key, value), e);
        }
    }

    @Override
    public void saveLong(String key, long value) {
        RequireUtils.requireNotBlank((String)key, (String)"Key cannot be blank");
        try {
            Preferences.userRoot().node(this.path).putLong(key, value);
            LOG.trace("Saved entity [key '{}', value '{}']", (Object)key, (Object)value);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to store value: [key '%s', value '%s']", key, value), e);
        }
    }

    @Override
    public void saveString(String key, String value) {
        RequireUtils.requireNotBlank((String)key, (String)"Key cannot be blank");
        try {
            if (Objects.nonNull(value)) {
                Preferences.userRoot().node(this.path).put(key, value);
                LOG.trace("Saved entity [key '{}', value '{}']", (Object)key, (Object)value);
            } else {
                this.delete(key);
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to store value: [key '%s', value '%s']", key, value), e);
        }
    }

    @Override
    public void saveBoolean(String key, boolean value) {
        RequireUtils.requireNotBlank((String)key, (String)"Key cannot be blank");
        try {
            Preferences.userRoot().node(this.path).putBoolean(key, value);
            LOG.trace("Saved entity [key '{}', value '{}']", (Object)key, (Object)value);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to store value: [key '%s', value '%s']", key, value), e);
        }
    }

    @Override
    public String[] keys() {
        try {
            return Preferences.userRoot().node(this.path).keys();
        }
        catch (IllegalStateException | BackingStoreException e) {
            throw new PersistenceException("Unable to retrieve key values", e);
        }
    }

    @Override
    public void delete(String key) {
        RequireUtils.requireNotBlank((String)key, (String)"Key cannot be blank");
        try {
            Preferences.userRoot().node(this.path).remove(key);
            LOG.trace("Deleted entity key '{}'", (Object)key);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new PersistenceException(String.format("Unable to delete value: [key '%s']", key), e);
        }
    }

    @Override
    public void clean() {
        Preferences prefs = Preferences.userRoot().node(this.path);
        try {
            prefs.removeNode();
            prefs.flush();
        }
        catch (IllegalStateException | BackingStoreException e) {
            throw new PersistenceException(String.format("Unable to clear preferences: [path '%s']", this.path), e);
        }
    }
}

