/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NumberPrefixProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(NumberPrefixProcessor.class);
    protected final Pattern pattern;

    NumberPrefixProcessor(String prefix) {
        RequireUtils.requireNotBlank((String)prefix, (String)"Prefix cannot be blank");
        this.pattern = Pattern.compile(String.format("\\[%s(#*)(-?[0-9]*)\\]", prefix));
    }

    protected String findAndReplace(String inputString, Integer num) {
        StringBuilder sb = new StringBuilder();
        Matcher m = this.pattern.matcher(inputString);
        while (m.find()) {
            String replacement = this.getReplacement(m.group(1), m.group(2), num);
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String getReplacement(String numberPatter, String startingNumber, Integer num) {
        Integer number = this.getReplacementNumber(startingNumber, num);
        if (StringUtils.isNotBlank((CharSequence)numberPatter)) {
            return this.formatter(numberPatter).format(number);
        }
        return number.toString();
    }

    private Integer getReplacementNumber(String startingNumber, Integer num) {
        if (StringUtils.isNotBlank((CharSequence)startingNumber)) {
            return num + Integer.parseInt(startingNumber);
        }
        return num;
    }

    private DecimalFormat formatter(String numberPattern) {
        try {
            if (StringUtils.isNotBlank((CharSequence)numberPattern)) {
                return new DecimalFormat(numberPattern.replaceAll("#", "0"));
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.error(String.format("Error applying pattern %s", numberPattern), (Throwable)iae);
        }
        return new DecimalFormat("00000");
    }
}

