/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.model;

import java.util.Optional;
import org.sejda.core.support.prefix.model.NameGenerationRequest;

public class PrefixTransformationContext {
    private String currentPrefix;
    private final String originalPrefix;
    private final NameGenerationRequest request;
    private boolean uniqueNames = false;

    public PrefixTransformationContext(String prefix, NameGenerationRequest request) {
        this.currentPrefix = prefix;
        this.originalPrefix = prefix;
        this.request = Optional.ofNullable(request).orElseGet(NameGenerationRequest::nameRequest);
    }

    public String currentPrefix() {
        return this.currentPrefix;
    }

    public void currentPrefix(String prefix) {
        this.currentPrefix = prefix;
    }

    public NameGenerationRequest request() {
        return this.request;
    }

    public boolean uniqueNames() {
        return this.uniqueNames;
    }

    public void uniqueNames(boolean uniqueNames) {
        this.uniqueNames = uniqueNames;
    }

    public boolean noTransformationApplied() {
        return this.originalPrefix.equals(this.currentPrefix);
    }
}

