/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix;

import java.util.Comparator;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.model.PrefixTransformationContext;
import org.sejda.core.support.prefix.processor.PrefixProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NameGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(NameGenerator.class);
    private final String prefix;

    private NameGenerator(String prefix) {
        this.prefix = StringUtils.defaultString((String)prefix);
    }

    public static NameGenerator nameGenerator(String prefix) {
        return new NameGenerator(prefix);
    }

    public String generate(NameGenerationRequest request) {
        RequireUtils.requireNotNullArg((Object)request, (String)"Unable to generate a name for a null request");
        PrefixTransformationContext context = new PrefixTransformationContext(this.prefix, request);
        LOG.trace("Starting processing prefix: '{}'", (Object)context.currentPrefix());
        ServiceLoader.load(PrefixProcessor.class).stream().map(ServiceLoader.Provider::get).sorted(Comparator.comparingInt(PrefixProcessor::order)).forEachOrdered(prefixProcessor -> {
            prefixProcessor.accept(context);
            LOG.trace("Prefix processed with {}, new value: '{}'", (Object)prefixProcessor.getClass().getSimpleName(), (Object)context.currentPrefix());
        });
        return context.currentPrefix();
    }
}

