/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.split;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.sejda.impl.sambox.component.optimization.NameResourcesDuplicator;
import org.sejda.impl.sambox.component.optimization.ResourceDictionaryCleaner;
import org.sejda.impl.sambox.component.optimization.ResourcesHitter;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageCopier {
    private static final Logger LOG = LoggerFactory.getLogger(PageCopier.class);
    private boolean optimize;
    private Consumer<PDPage> hitAndClean = new NameResourcesDuplicator().andThen(new ResourcesHitter()).andThen(new ResourceDictionaryCleaner()::clean);

    public PageCopier(boolean optimize) {
        this.optimize = optimize;
    }

    public PDPage copyOf(PDPage page) {
        PDPage copy = new PDPage(page.getCOSObject().duplicate());
        copy.setCropBox(page.getCropBox());
        copy.setMediaBox(page.getMediaBox());
        copy.setResources(page.getResources());
        copy.setRotation(page.getRotation());
        copy.getCOSObject().removeItem(COSName.B);
        COSArray annots = (COSArray)page.getCOSObject().getDictionaryObject(COSName.ANNOTS, COSArray.class);
        if (Objects.nonNull(annots)) {
            COSArray cleanedAnnotationsCopy = new COSArray();
            annots.stream().map(COSBase::getCOSObject).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).map(COSDictionary::duplicate).forEach(a -> {
                a.removeItem(COSName.P);
                a.removeItem(COSName.DEST);
                a.removeItem(COSName.getPDFName((String)"Popup"));
                a.removeItem(COSName.PARENT);
                if (Optional.ofNullable((COSDictionary)a.getDictionaryObject(COSName.A, COSDictionary.class)).map(d -> d.containsKey(COSName.D)).orElse(false).booleanValue()) {
                    a.removeItem(COSName.A);
                }
                cleanedAnnotationsCopy.add((COSBase)a);
            });
            copy.getCOSObject().setItem(COSName.ANNOTS, (COSBase)cleanedAnnotationsCopy);
        }
        if (this.optimize) {
            this.hitAndClean.accept(copy);
        }
        this.duplicatePageStreams(page, copy);
        copy.sanitizeDictionary();
        return copy;
    }

    private void duplicatePageStreams(PDPage page, PDPage copy) {
        COSStream stream = (COSStream)page.getCOSObject().getDictionaryObject(COSName.CONTENTS, COSStream.class);
        if (Objects.nonNull(stream)) {
            copy.getCOSObject().setItem(COSName.CONTENTS, (COSBase)new MockPageStream(stream));
        } else {
            COSArray streams = (COSArray)page.getCOSObject().getDictionaryObject(COSName.CONTENTS, COSArray.class);
            if (Objects.nonNull(streams)) {
                COSArray streamsCopy = new COSArray();
                streams.stream().map(COSBase::getCOSObject).filter(s -> s instanceof COSStream).map(COSStream.class::cast).map(x$0 -> new MockPageStream((COSStream)x$0)).forEach(arg_0 -> ((COSArray)streamsCopy).add(arg_0));
                copy.getCOSObject().setItem(COSName.CONTENTS, (COSBase)streamsCopy);
            }
        }
    }

    private class MockPageStream
    extends COSStream {
        private long length;

        private MockPageStream(COSStream original) {
            super(original.duplicate());
            this.length = 0L;
            try {
                this.length = original.getFilteredLength();
            }
            catch (IOException e) {
                LOG.error("An error occurred while calculating the COSStream length", (Throwable)e);
            }
        }

        public long getFilteredLength() throws IOException {
            return this.length;
        }
    }
}

