/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sejda.core.Sejda;
import org.sejda.impl.sambox.component.PDDocumentAccessPermission;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.impl.sambox.util.PageLabelUtils;
import org.sejda.impl.sambox.util.ViewerPreferencesUtils;
import org.sejda.model.encryption.EncryptionAtRestPolicy;
import org.sejda.model.encryption.NoEncryptionAtRest;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.image.ImageColorType;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.model.pdf.label.PdfPageLabel;
import org.sejda.model.pdf.viewerpreference.PdfPageLayout;
import org.sejda.model.pdf.viewerpreference.PdfPageMode;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.encryption.StandardSecurity;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDDocumentInformation;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.PageLayout;
import org.sejda.sambox.pdmodel.PageMode;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.sejda.sambox.rendering.ImageType;
import org.sejda.sambox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDDocumentHandler
implements Closeable {
    public static final String SAMBOX_USE_ASYNC_WRITER = "sejda.sambox.asyncwriter";
    private static final Logger LOG = LoggerFactory.getLogger(PDDocumentHandler.class);
    private static final WriteOption[] COMPRESSED_OPTS = new WriteOption[]{WriteOption.COMPRESS_STREAMS, WriteOption.OBJECT_STREAMS, WriteOption.XREF_STREAM};
    private PDDocument document;
    private PDDocumentAccessPermission permissions;
    private Set<WriteOption> writeOptions = new HashSet<WriteOption>();
    private boolean updateProducerModifiedDate = true;

    public PDDocumentHandler(PDDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("PDDocument cannot be null.");
        }
        if (Boolean.getBoolean("sejda.perform.eager.assertions")) {
            document.assertNumberOfPagesIsAccurate();
        }
        this.document = document;
        this.permissions = new PDDocumentAccessPermission(document);
    }

    public PDDocumentHandler() {
        this.document = new PDDocument();
        this.permissions = new PDDocumentAccessPermission(this.document);
        COSDictionary pieceInfo = new COSDictionary();
        COSDictionary pieceLastMod = new COSDictionary();
        pieceLastMod.setDate(COSName.LAST_MODIFIED, Calendar.getInstance());
        pieceInfo.setItem(new String(new byte[]{115, 106, 100, 97, 95}), (COSBase)pieceLastMod);
        this.document.getDocumentCatalog().getCOSObject().setItem(COSName.PIECE_INFO, (COSBase)pieceInfo);
    }

    public void setCreatorOnPDDocument() {
        if (!Sejda.CREATOR.isEmpty()) {
            this.document.getDocumentInformation().setCreator(Sejda.CREATOR);
        }
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.document.setDocumentInformation(info);
    }

    public void setDocumentTitle(String title) {
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setTitle(title);
        this.document.setDocumentInformation(info);
    }

    public PDDocumentAccessPermission getPermissions() {
        return this.permissions;
    }

    public void setPageLayoutOnDocument(PdfPageLayout layout) {
        this.setPageLayout(ViewerPreferencesUtils.getPageLayout(layout));
        LOG.trace("Page layout set to '{}'", (Object)layout);
    }

    public void setPageModeOnDocument(PdfPageMode mode) {
        this.setPageMode(ViewerPreferencesUtils.getPageMode(mode));
        LOG.trace("Page mode set to '{}'", (Object)mode);
    }

    public void setPageLabelsOnDocument(Map<Integer, PdfPageLabel> labels) {
        this.document.getDocumentCatalog().setPageLabels(PageLabelUtils.getLabels(labels, this.getNumberOfPages()));
        LOG.trace("Page labels set");
    }

    public void setVersionOnPDDocument(PdfVersion version) {
        if (version != null) {
            this.document.setVersion(version.getVersionString());
            LOG.trace("Version set to '{}'", (Object)version);
        }
    }

    public void addWriteOption(WriteOption ... opts) {
        this.writeOptions.addAll(Arrays.asList(opts));
    }

    public void removeWriteOption(WriteOption ... opts) {
        for (WriteOption opt : opts) {
            this.writeOptions.remove(opt);
        }
    }

    public void setCompress(boolean compress) {
        if (compress) {
            this.addWriteOption(COMPRESSED_OPTS);
        } else {
            this.removeWriteOption(COMPRESSED_OPTS);
        }
    }

    public PDViewerPreferences getViewerPreferences() {
        PDViewerPreferences retVal = this.document.getDocumentCatalog().getViewerPreferences();
        if (retVal == null) {
            retVal = new PDViewerPreferences(new COSDictionary());
        }
        return retVal;
    }

    public void setViewerPreferences(PDViewerPreferences preferences) {
        this.document.getDocumentCatalog().setViewerPreferences(preferences);
    }

    @Override
    public void close() throws IOException {
        this.document.close();
        FontUtils.clearLoadedFontCache(this.document);
    }

    public void savePDDocument(File file) throws TaskException {
        this.savePDDocument(file, null, (EncryptionAtRestPolicy)NoEncryptionAtRest.INSTANCE);
    }

    public void savePDDocument(File file, EncryptionAtRestPolicy encryptionAtRestSecurity) throws TaskException {
        this.savePDDocument(file, null, encryptionAtRestSecurity);
    }

    public void savePDDocument(File file, StandardSecurity security, EncryptionAtRestPolicy encryptionAtRestSecurity) throws TaskException {
        try {
            if (Boolean.getBoolean(SAMBOX_USE_ASYNC_WRITER)) {
                this.addWriteOption(WriteOption.ASYNC_BODY_WRITE);
            }
            if (!this.updateProducerModifiedDate) {
                this.addWriteOption(WriteOption.NO_METADATA_PRODUCER_MODIFIED_DATE_UPDATE);
            }
            if (encryptionAtRestSecurity instanceof NoEncryptionAtRest) {
                LOG.trace("Saving document to {} using options {}", (Object)file, this.writeOptions);
                this.document.writeTo(file, security, (WriteOption[])this.writeOptions.toArray(WriteOption[]::new));
            } else {
                LOG.trace("Saving document to {} using options {}", (Object)file, this.writeOptions);
                this.document.writeTo(encryptionAtRestSecurity.encrypt((OutputStream)new FileOutputStream(file)), security, (WriteOption[])this.writeOptions.toArray(WriteOption[]::new));
            }
        }
        catch (IOException e) {
            throw new TaskIOException("Unable to save to temporary file.", (Throwable)e);
        }
    }

    public int getNumberOfPages() {
        return this.document.getNumberOfPages();
    }

    public PDDocument getUnderlyingPDDocument() {
        return this.document;
    }

    public PDDocumentCatalog catalog() {
        return this.document.getDocumentCatalog();
    }

    public PDPage importPage(PDPage page) {
        PDPage imported = new PDPage(page.getCOSObject().duplicate());
        imported.setCropBox(page.getCropBox());
        imported.setMediaBox(page.getMediaBox());
        imported.setBleedBox(page.getBleedBox());
        imported.setResources(page.getResources());
        imported.setRotation(page.getRotation());
        imported.getCOSObject().removeItem(COSName.B);
        imported.sanitizeDictionary();
        return this.addPage(imported);
    }

    public PDPage addPage(PDPage page) {
        this.document.addPage(page);
        return page;
    }

    public void removePage(int pageNumber) {
        this.document.removePage(pageNumber - 1);
    }

    public void movePageToDocumentEnd(int oldPageNumber) {
        if (oldPageNumber == this.document.getNumberOfPages()) {
            return;
        }
        PDPage page = this.getPage(oldPageNumber);
        this.document.addPage(page);
        this.document.removePage(oldPageNumber - 1);
    }

    public PDPage getPage(int pageNumber) {
        return this.document.getPage(pageNumber - 1);
    }

    public PDPageTree getPages() {
        return this.document.getPages();
    }

    public void initialiseBasedOn(PDDocument other) {
        this.setDocumentInformation(other.getDocumentInformation());
        this.setViewerPreferences(other.getDocumentCatalog().getViewerPreferences());
        if (other.getDocumentCatalog().getCOSObject().containsKey(COSName.PAGE_LAYOUT)) {
            this.setPageLayout(other.getDocumentCatalog().getPageLayout());
        }
        if (other.getDocumentCatalog().getCOSObject().containsKey(COSName.PAGE_MODE)) {
            this.setPageMode(other.getDocumentCatalog().getPageMode());
        }
        this.document.getDocumentCatalog().setLanguage(other.getDocumentCatalog().getLanguage());
        this.setCreatorOnPDDocument();
    }

    public BufferedImage renderImage(int pageNumber, int dpi, ImageColorType type) throws TaskException {
        try {
            PDFRenderer pdfRenderer = new PDFRenderer(this.document);
            return pdfRenderer.renderImageWithDPI(pageNumber - 1, (float)dpi, this.toSamboxImageType(type));
        }
        catch (IOException ex) {
            LOG.error("Failed to render page " + pageNumber, (Throwable)ex);
            throw new TaskException("Failed to render page " + pageNumber, (Throwable)ex);
        }
    }

    private ImageType toSamboxImageType(ImageColorType colorType) {
        for (ImageType type : ImageType.values()) {
            if (type.toBufferedImageType() != colorType.getBufferedImageType()) continue;
            return type;
        }
        throw new RuntimeException("Could not find a suitable image type for color type:" + String.valueOf(colorType));
    }

    public void setDocumentOutline(PDDocumentOutline outline) {
        this.document.getDocumentCatalog().setDocumentOutline(outline);
    }

    public void setDocumentAcroForm(PDAcroForm acroForm) {
        this.document.getDocumentCatalog().setAcroForm(acroForm);
    }

    private void setPageMode(PageMode pageMode) {
        this.document.getDocumentCatalog().setPageMode(pageMode);
    }

    private void setPageLayout(PageLayout pageLayout) {
        this.document.getDocumentCatalog().setPageLayout(pageLayout);
    }

    public PDPage addBlankPageIfOdd(PDRectangle mediaBox) {
        if (this.document.getNumberOfPages() % 2 != 0) {
            return this.addBlankPage(mediaBox);
        }
        return null;
    }

    public PDPage addBlankPage(PDRectangle mediaBox) {
        LOG.debug("Adding blank page");
        return this.addPage(new PDPage(Optional.ofNullable(mediaBox).orElse(PDRectangle.LETTER)));
    }

    public PDPage addBlankPageAfter(int pageNumber) {
        PDPage target = this.document.getPage(pageNumber - 1);
        PDPage result = new PDPage(target.getMediaBox().rotate(target.getRotation()));
        this.document.getPages().insertAfter(result, target);
        return result;
    }

    public PDPage addBlankPageBefore(int pageNumber) {
        PDPage target = this.document.getPage(pageNumber - 1);
        PDPage result = new PDPage(target.getMediaBox().rotate(target.getRotation()));
        this.document.getPages().insertBefore(result, target);
        return result;
    }

    public boolean isUpdateProducerModifiedDate() {
        return this.updateProducerModifiedDate;
    }

    public void setUpdateProducerModifiedDate(boolean updateProducerModifiedDate) {
        this.updateProducerModifiedDate = updateProducerModifiedDate;
    }
}

