/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sejda.commons.LookupTable;
import org.sejda.commons.util.RequireUtils;
import org.sejda.impl.sambox.component.OutlineUtils;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineDistiller {
    private static final Logger LOG = LoggerFactory.getLogger(OutlineDistiller.class);
    private PDDocument document;

    public OutlineDistiller(PDDocument document) {
        RequireUtils.requireNotNullArg((Object)document, (String)"Unable to retrieve bookmarks from a null document.");
        this.document = document;
    }

    public void appendRelevantOutlineTo(PDOutlineNode to, LookupTable<PDPage> pagesLookup) {
        Objects.requireNonNull(to, "Unable to merge relevant outline items to a null outline.");
        if (!pagesLookup.isEmpty()) {
            Optional.ofNullable(this.document.getDocumentCatalog().getDocumentOutline()).ifPresent(outline -> {
                this.cloneOutline((PDDocumentOutline)outline, to, pagesLookup);
                LOG.debug("Appended relevant outline items");
            });
        }
    }

    private String objIdOf(COSObjectable o) {
        try {
            COSObjectKey ident = o.getCOSObject().id().objectIdentifier;
            String gen = ident.generation() == 0 ? "" : "" + ident.generation();
            return ident.objectNumber() + "R" + gen;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void cloneOutline(PDDocumentOutline from, PDOutlineNode to, LookupTable<PDPage> pagesLookup) {
        HashSet<PDOutlineItem> alreadyVisited = new HashSet<PDOutlineItem>();
        for (PDOutlineItem child : from.children()) {
            this.cloneNode(child, pagesLookup, alreadyVisited).ifPresent(arg_0 -> ((PDOutlineNode)to).addLast(arg_0));
        }
    }

    private Optional<PDOutlineItem> cloneNode(PDOutlineItem node, LookupTable<PDPage> pagesLookup, Set<PDOutlineItem> alreadyVisited) {
        String nodeObjId = this.objIdOf((COSObjectable)node);
        LOG.debug("Cloning node: " + nodeObjId + " " + node.getTitle() + " #" + node.hashCode());
        if (alreadyVisited.contains(node)) {
            LOG.warn("Detected already visited node: " + nodeObjId + " " + node.getTitle() + " #" + node.hashCode() + ", skipping at cloning to avoid infinite loop");
            return Optional.empty();
        }
        alreadyVisited.add(node);
        if (node.hasChildren()) {
            PDOutlineItem clone = new PDOutlineItem();
            for (PDOutlineItem current : node.children()) {
                if (current.equals((Object)node)) {
                    LOG.warn("Outline item has a child pointing to the parent, skipping at cloning");
                    continue;
                }
                this.cloneNode(current, pagesLookup, alreadyVisited).ifPresent(arg_0 -> ((PDOutlineItem)clone).addLast(arg_0));
            }
            Optional<PDPageDestination> pageDestination = OutlineUtils.toPageDestination(node, this.document.getDocumentCatalog());
            Optional<PDPage> destinationPage = pageDestination.map(d -> OutlineUtils.resolvePageDestination(d, this.document)).map(arg_0 -> pagesLookup.lookup(arg_0));
            if (clone.hasChildren() || destinationPage.isPresent()) {
                OutlineUtils.copyOutlineDictionary(node, clone);
                destinationPage.ifPresent(p -> clone.setDestination((PDDestination)OutlineUtils.clonePageDestination((PDPageDestination)pageDestination.get(), p)));
                return Optional.of(clone);
            }
            return Optional.empty();
        }
        return this.cloneLeafIfNeeded(node, pagesLookup);
    }

    private Optional<PDOutlineItem> cloneLeafIfNeeded(PDOutlineItem origin, LookupTable<PDPage> pagesLookup) {
        return OutlineUtils.toPageDestination(origin, this.document.getDocumentCatalog()).flatMap(d -> {
            PDPage mapped = (PDPage)pagesLookup.lookup((Object)OutlineUtils.resolvePageDestination(d, this.document));
            if (mapped != null) {
                PDOutlineItem retVal = new PDOutlineItem();
                OutlineUtils.copyOutlineDictionary(origin, retVal);
                retVal.setDestination((PDDestination)OutlineUtils.clonePageDestination(d, mapped));
                return Optional.of(retVal);
            }
            return Optional.empty();
        });
    }
}

