/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sejda.commons.LookupTable;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.impl.sambox.util.AcroFormUtils;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDFieldFactory;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDVariableText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcroFormsMerger {
    private static final Logger LOG = LoggerFactory.getLogger(AcroFormsMerger.class);
    private static final COSName[] FIELD_KEYS = new COSName[]{COSName.FT, COSName.PARENT, COSName.KIDS, COSName.T, COSName.TU, COSName.TM, COSName.FF, COSName.V, COSName.DV, COSName.Q, COSName.DS, COSName.RV, COSName.OPT, COSName.MAX_LEN, COSName.TI, COSName.I, COSName.LOCK, COSName.SV, COSName.DATAPREP};
    private static final COSName[] WIDGET_KEYS = new COSName[]{COSName.TYPE, COSName.SUBTYPE, COSName.RECT, COSName.CONTENTS, COSName.P, COSName.NM, COSName.M, COSName.F, COSName.AP, COSName.AS, COSName.BORDER, COSName.C, COSName.STRUCT_PARENT, COSName.OC, COSName.AF, COSName.CA, COSName.CA_NS, COSName.LANG, COSName.BM, COSName.H, COSName.MK, COSName.A, COSName.BS, COSName.PMD};
    private AcroFormPolicy policy;
    private PDAcroForm form;
    private String random = Long.toString(UUID.randomUUID().getMostSignificantBits(), 36);
    private Long counter = 0L;
    private final BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> createOrReuseTerminalField = (existing, fieldsLookup) -> {
        boolean shouldCreateNewAndRename;
        PDField previouslyCreated = Optional.ofNullable(this.getMergedField(existing.getFullyQualifiedName())).orElseGet(() -> (PDField)fieldsLookup.lookup(existing));
        boolean shouldCreateNew = Objects.isNull(previouslyCreated);
        boolean bl = shouldCreateNewAndRename = previouslyCreated != null && (!previouslyCreated.getClass().equals(existing.getClass()) || !previouslyCreated.getValueAsString().equals(existing.getValueAsString()));
        if (shouldCreateNew || shouldCreateNewAndRename) {
            previouslyCreated = PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)existing.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)existing.getParent())));
            if (shouldCreateNewAndRename) {
                LOG.warn("Cannot merge terminal field because another field with the same name but different value already exists: {}", (Object)existing.getFullyQualifiedName());
                Object[] objectArray = new Object[3];
                objectArray[0] = AcroFormsMerger.removeDotsIfAny(existing.getPartialName());
                objectArray[1] = this.random;
                this.counter = this.counter + 1L;
                objectArray[2] = this.counter;
                previouslyCreated.setPartialName(String.format("%s%s%d", objectArray));
            }
            previouslyCreated.getCOSObject().removeItem(COSName.KIDS);
            fieldsLookup.addLookupEntry(existing, (Object)previouslyCreated);
        }
        if (!previouslyCreated.isTerminal()) {
            LOG.warn("Cannot merge terminal field because a non terminal field with the same name already exists: {}", (Object)existing.getFullyQualifiedName());
            return null;
        }
        return (PDTerminalField)previouslyCreated;
    };
    private final BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> createRenamingTerminalField = (existing, fieldsLookup) -> {
        PDTerminalField newField = (PDTerminalField)PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)existing.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)existing.getParent())));
        if (Objects.nonNull(this.getMergedField(existing.getFullyQualifiedName())) || fieldsLookup.hasLookupFor(existing)) {
            String partialName = AcroFormsMerger.removeDotsIfAny(existing.getPartialName());
            Object[] objectArray = new Object[3];
            objectArray[0] = partialName;
            objectArray[1] = this.random;
            this.counter = this.counter + 1L;
            objectArray[2] = this.counter;
            newField.setPartialName(String.format("%s%s%d", objectArray));
            LOG.info("Existing terminal field renamed from {} to {}", (Object)partialName, (Object)newField.getPartialName());
        }
        newField.getCOSObject().removeItem(COSName.KIDS);
        fieldsLookup.addLookupEntry(existing, (Object)newField);
        return newField;
    };
    private final BiConsumer<PDField, LookupTable<PDField>> createOrReuseNonTerminalField = (existing, fieldsLookup) -> {
        if (!fieldsLookup.hasLookupFor(existing)) {
            PDField mergedField = this.getMergedField(existing.getFullyQualifiedName());
            if (Objects.isNull(mergedField)) {
                mergedField = PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)existing.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)existing.getParent())));
                mergedField.getCOSObject().removeItem(COSName.KIDS);
            } else if (mergedField.isTerminal()) {
                mergedField = PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)existing.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)existing.getParent())));
                mergedField.getCOSObject().removeItem(COSName.KIDS);
                Object[] objectArray = new Object[3];
                objectArray[0] = AcroFormsMerger.removeDotsIfAny(existing.getPartialName());
                objectArray[1] = this.random;
                this.counter = this.counter + 1L;
                objectArray[2] = this.counter;
                mergedField.setPartialName(String.format("%s%s%d", objectArray));
                LOG.warn("Cannot reuse merged terminal field {} as a non terminal field, renaming it to {}", (Object)existing.getPartialName(), (Object)mergedField.getPartialName());
            }
            fieldsLookup.addLookupEntry(existing, (Object)mergedField);
        }
    };
    private final BiConsumer<PDField, LookupTable<PDField>> createRenamingNonTerminalField = (field, fieldsLookup) -> {
        PDField newField = PDFieldFactory.createFieldAddingChildToParent((PDAcroForm)this.form, (COSDictionary)field.getCOSObject().duplicate(), (PDNonTerminalField)((PDNonTerminalField)fieldsLookup.lookup((Object)field.getParent())));
        if (this.getMergedField(field.getFullyQualifiedName()) != null || fieldsLookup.hasLookupFor(field)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AcroFormsMerger.removeDotsIfAny(field.getPartialName());
            objectArray[1] = this.random;
            this.counter = this.counter + 1L;
            objectArray[2] = this.counter;
            newField.setPartialName(String.format("%s%s%d", objectArray));
            LOG.info("Existing non terminal field renamed from {} to {}", (Object)field.getPartialName(), (Object)newField.getPartialName());
        }
        newField.getCOSObject().removeItem(COSName.KIDS);
        fieldsLookup.addLookupEntry(field, (Object)newField);
    };

    private static String removeDotsIfAny(String s) {
        if (s == null) {
            return null;
        }
        return s.replace(".", "");
    }

    private PDField getMergedField(String fullyQualifiedName) {
        return Optional.ofNullable(fullyQualifiedName).map(arg_0 -> ((PDAcroForm)this.form).getField(arg_0)).orElse(null);
    }

    public AcroFormsMerger(AcroFormPolicy policy, PDDocument destination) {
        this.policy = policy;
        this.form = new PDAcroForm(destination);
    }

    public void mergeForm(PDAcroForm originalForm, LookupTable<PDAnnotation> annotationsLookup) {
        if (Objects.nonNull(originalForm)) {
            if (originalForm.hasXFA()) {
                LOG.warn("The AcroForm has XFA resources which will be ignored");
            }
            LOG.debug("Merging acroforms with policy {}", (Object)this.policy);
            switch (this.policy) {
                case MERGE_RENAMING_EXISTING_FIELDS: {
                    this.updateForm(originalForm, annotationsLookup, this.createRenamingTerminalField, this.createRenamingNonTerminalField);
                    break;
                }
                case MERGE: {
                    this.updateForm(originalForm, annotationsLookup, this.createOrReuseTerminalField, this.createOrReuseNonTerminalField);
                    break;
                }
                case FLATTEN: {
                    this.updateForm(originalForm, annotationsLookup, this.createRenamingTerminalField, this.createRenamingNonTerminalField);
                    this.flatten();
                    break;
                }
                default: {
                    LOG.debug("Discarding acroform");
                    break;
                }
            }
        } else {
            LOG.debug("Skipped acroform merge, nothing to merge");
        }
    }

    private void removeFieldKeysFromWidgets(Collection<PDAnnotationWidget> annotations) {
        annotations.stream().map(PDDictionaryWrapper::getCOSObject).forEach(a -> {
            Arrays.stream(FIELD_KEYS).forEach(key -> {
                if (this.policy == AcroFormPolicy.MERGE_RENAMING_EXISTING_FIELDS && key == COSName.Q) {
                    return;
                }
                a.removeItem(key);
            });
            if (annotations.size() == 1 && this.policy != AcroFormPolicy.MERGE_RENAMING_EXISTING_FIELDS) {
                a.removeItem(COSName.DA);
            }
        });
        LOG.trace("Removed fields keys from widget annotations");
    }

    private void updateForm(PDAcroForm originalForm, LookupTable<PDAnnotation> annotationsLookup, BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> getTerminalField, BiConsumer<PDField, LookupTable<PDField>> createNonTerminalField) {
        AcroFormUtils.mergeDefaults(originalForm, this.form);
        LookupTable fieldsLookup = new LookupTable();
        Set<PDAnnotationWidget> allRelevantWidgets = annotationsLookup.keys().stream().filter(a -> a instanceof PDAnnotationWidget).map(a -> (PDAnnotationWidget)a).collect(Collectors.toSet());
        HashSet rootFields = new HashSet();
        originalForm.getFieldTree().stream().forEach(f -> this.mergeField((PDField)f, annotationsLookup, getTerminalField, createNonTerminalField, (LookupTable<PDField>)fieldsLookup, Optional.of(allRelevantWidgets::remove)));
        originalForm.getFields().stream().map(arg_0 -> ((LookupTable)fieldsLookup).lookup(arg_0)).filter(Objects::nonNull).forEach(rootFields::add);
        if (!allRelevantWidgets.isEmpty()) {
            LOG.info("Found relevant widget annotations ({}) not linked to the form", (Object)allRelevantWidgets.size());
            PDAcroForm dummy = new PDAcroForm(null);
            allRelevantWidgets.forEach(w -> {
                COSDictionary currentField = w.getCOSObject();
                while (Objects.nonNull(currentField.getDictionaryObject(COSName.PARENT, COSDictionary.class))) {
                    currentField = (COSDictionary)currentField.getDictionaryObject(COSName.PARENT, COSDictionary.class);
                }
                dummy.addFields(List.of(PDFieldFactory.createField((PDAcroForm)originalForm, (COSDictionary)currentField, null)));
            });
            dummy.getFieldTree().stream().forEach(f -> this.mergeField((PDField)f, annotationsLookup, getTerminalField, createNonTerminalField, (LookupTable<PDField>)fieldsLookup, Optional.empty()));
            dummy.getFields().stream().map(arg_0 -> ((LookupTable)fieldsLookup).lookup(arg_0)).filter(Objects::nonNull).forEach(rootFields::add);
        }
        List currentRoots = this.form.getFields();
        this.form.addFields((Collection)rootFields.stream().filter(f -> !currentRoots.contains(f)).collect(Collectors.toList()));
        this.mergeCalculationOrder(originalForm, (LookupTable<PDField>)fieldsLookup);
    }

    private void mergeField(PDField field, LookupTable<PDAnnotation> annotationsLookup, BiFunction<PDTerminalField, LookupTable<PDField>, PDTerminalField> getTerminalField, BiConsumer<PDField, LookupTable<PDField>> createNonTerminalField, LookupTable<PDField> fieldsLookup, Optional<Consumer<PDAnnotationWidget>> onProcessedWidget) {
        if (!field.isTerminal()) {
            createNonTerminalField.accept(field, fieldsLookup);
        } else {
            List<PDAnnotationWidget> relevantWidgets = this.findMappedWidgetsFor((PDTerminalField)field, annotationsLookup);
            if (!relevantWidgets.isEmpty()) {
                PDTerminalField terminalField = getTerminalField.apply((PDTerminalField)field, fieldsLookup);
                if (Objects.nonNull(terminalField)) {
                    this.removeFieldKeysFromWidgets(relevantWidgets);
                    for (PDAnnotationWidget widget : relevantWidgets) {
                        terminalField.addWidgetIfMissing(widget);
                        onProcessedWidget.ifPresent(c -> field.getWidgets().forEach(c));
                    }
                    terminalField.getCOSObject().removeItems(WIDGET_KEYS);
                }
            } else {
                LOG.debug("Discarded not relevant field {}", (Object)field.getFullyQualifiedName());
            }
        }
    }

    private void mergeCalculationOrder(PDAcroForm originalForm, LookupTable<PDField> fieldsLookup) {
        List<PDField> co = originalForm.getCalculationOrder().stream().map(arg_0 -> fieldsLookup.lookup(arg_0)).filter(Objects::nonNull).toList();
        if (co.size() > 0) {
            COSArray formCo = Optional.ofNullable((COSArray)this.form.getCOSObject().getDictionaryObject(COSName.CO, COSArray.class)).orElseGet(COSArray::new);
            for (PDField field : co) {
                formCo.add((COSObjectable)field);
            }
            this.form.setCalculationOrder(formCo);
        }
    }

    private List<PDAnnotationWidget> findMappedWidgetsFor(PDTerminalField field, LookupTable<PDAnnotation> annotationsLookup) {
        return field.getWidgets().stream().map(arg_0 -> annotationsLookup.lookup(arg_0)).filter(w -> w instanceof PDAnnotationWidget).map(w -> (PDAnnotationWidget)w).collect(Collectors.toList());
    }

    private void flatten() {
        try {
            ArrayList<PDField> fields = new ArrayList<PDField>();
            for (PDField field : this.form.getFieldTree()) {
                fields.add(field);
                if (!(field instanceof PDVariableText)) continue;
                PDVariableText variableText = (PDVariableText)field;
                AcroFormUtils.ensureValueCanBeDisplayed(variableText, this.form.getDocument());
            }
            this.form.flatten(fields, this.form.isNeedAppearances());
        }
        catch (IOException | UnsupportedOperationException ex) {
            LOG.warn("Failed to flatten form", (Throwable)ex);
        }
    }

    public PDAcroForm getForm() {
        for (PDField current : this.form.getFieldTree()) {
            if (!current.isTerminal() && !((PDNonTerminalField)current).hasChildren()) {
                LOG.info("Removing non terminal field with no child {}", (Object)current.getFullyQualifiedName());
                if (Objects.nonNull(current.getParent())) {
                    current.getParent().removeChild(current);
                    continue;
                }
                this.form.removeField(current);
                continue;
            }
            if (!SignatureClipper.clipSignature(current)) continue;
            this.form.setSignaturesExist(true);
        }
        if (StringUtils.isBlank((CharSequence)this.form.getDefaultAppearance())) {
            this.form.setDefaultAppearance("/Helv 0 Tf 0 g ");
        }
        return this.form;
    }
}

