/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.BasePdfToImageTask;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.image.AbstractPdfToSingleImageParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfToSingleImageTask<T extends AbstractPdfToSingleImageParameters>
extends BasePdfToImageTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfToSingleImageTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener = null;
    private PDDocumentHandler documentHandler = null;

    @Override
    public void before(T parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        if (!this.getWriter().supportMultiImage()) {
            throw new TaskExecutionException("Selected ImageWriter doesn't support multiple images in the same file");
        }
        this.outputWriter = OutputWriters.newSingleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
        this.sourceOpener = new DefaultPdfSourceOpener(executionContext);
    }

    public void execute(T parameters) throws TaskException {
        File tmpFile = org.sejda.model.util.IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        LOG.debug("Opening {}", (Object)parameters.getSource());
        this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)parameters.getSource());
        this.documentHandler = (PDDocumentHandler)parameters.getSource().open(this.sourceOpener);
        Set requestedPages = parameters.getPages(this.documentHandler.getNumberOfPages());
        int numberOfPages = requestedPages.size();
        LOG.trace("Found {} pages", (Object)numberOfPages);
        int currentStep = 0;
        int totalSteps = numberOfPages;
        this.getWriter().openDestination(tmpFile, parameters);
        Iterator iterator = requestedPages.iterator();
        while (iterator.hasNext()) {
            int page = (Integer)iterator.next();
            ++currentStep;
            LOG.trace("Converting page {}", (Object)page);
            try {
                BufferedImage pageImage = this.documentHandler.renderImage(page, parameters.getResolutionInDpi(), parameters.getOutputImageColorType());
                this.getWriter().write((RenderedImage)pageImage, parameters);
            }
            catch (TaskException e) {
                this.executionContext().assertTaskIsLenient((Exception)((Object)e));
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be converted", page), (Exception)((Object)e));
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(totalSteps);
        }
        this.getWriter().closeDestination();
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Document converted to {} and saved to {}", (Object)parameters.getOutputImageType(), (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        super.after();
        IOUtils.closeQuietly((Closeable)this.documentHandler);
    }
}

