/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.sejda.commons.LookupTable;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.AnnotationsDistiller;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.AddBackPagesParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddBackPagesTask
extends BaseTask<AddBackPagesParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(AddBackPagesTask.class);
    private int totalSteps;
    private PDDocumentHandler sourceDocumentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PDDocumentHandler backPagesSource;
    private PDDocumentHandler destinationDocument;

    public void before(AddBackPagesParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener(executionContext);
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(AddBackPagesParameters parameters) throws TaskException {
        LOG.debug("Opening back pages source {}", (Object)parameters.getBackPagesSource());
        this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)parameters.getBackPagesSource());
        this.backPagesSource = (PDDocumentHandler)parameters.getBackPagesSource().open(this.documentLoader);
        List<PDPage> back = parameters.getPages(this.backPagesSource.getNumberOfPages()).stream().map(p -> this.backPagesSource.getPage((int)p)).toList();
        if (back.size() == 0) {
            throw new TaskExecutionException("No back page was selected");
        }
        LOG.debug("Retrieved {} back pages", (Object)back.size());
        for (PdfSource source : parameters.getSourceList()) {
            int fileNumber = this.executionContext().incrementAndGetOutputDocumentsCounter();
            this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
            this.destinationDocument = new PDDocumentHandler();
            this.destinationDocument.setCreatorOnPDDocument();
            this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
            this.destinationDocument.setCompress(parameters.isCompress());
            LOG.debug("Opening {}", (Object)source);
            this.sourceDocumentHandler = (PDDocumentHandler)source.open(this.documentLoader);
            this.sourceDocumentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
            File tmpFile = org.sejda.model.util.IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            int pageCounter = 0;
            LookupTable pagesLookup = new LookupTable();
            LOG.debug("Adding pages and back pages");
            for (PDPage current : this.sourceDocumentHandler.getPages()) {
                pagesLookup.addLookupEntry((Object)current, (Object)this.destinationDocument.importPage(current));
                if (++pageCounter % parameters.getStep() != 0) continue;
                back.forEach(p -> this.destinationDocument.importPage((PDPage)p));
            }
            LookupTable<PDAnnotation> annotationsLookup = new AnnotationsDistiller(this.sourceDocumentHandler.getUnderlyingPDDocument()).retainRelevantAnnotations((LookupTable<PDPage>)pagesLookup);
            SignatureClipper.clipSignatures(annotationsLookup.values());
            this.destinationDocument.savePDDocument(tmpFile, parameters.getOutput().getEncryptionAtRestPolicy());
            String outName = Optional.ofNullable(parameters.getSpecificResultFilename(fileNumber)).orElseGet(() -> NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(fileNumber)));
            this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            IOUtils.closeQuietly((Closeable)this.destinationDocument);
            IOUtils.closeQuietly((Closeable)this.sourceDocumentHandler);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(fileNumber).outOf(this.totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        IOUtils.closeQuietly((Closeable)this.backPagesSource);
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Back pages added after every {} pages to {} input documents and written to {}", new Object[]{parameters.getStep(), parameters.getSourceList().size(), parameters.getOutput()});
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.backPagesSource);
        IOUtils.closeQuietly((Closeable)this.destinationDocument);
        IOUtils.closeQuietly((Closeable)this.sourceDocumentHandler);
    }
}

