/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.rotation;

import org.sejda.model.FriendlyNamed;

public enum Rotation implements FriendlyNamed
{
    DEGREES_0(0),
    DEGREES_90(90),
    DEGREES_180(180),
    DEGREES_270(270);

    private static final int D_360 = 360;
    private static final int D_90 = 90;
    private static final int D_270 = 270;
    private final int degrees;
    private final String displayName;

    private Rotation(int degrees) {
        this.displayName = String.valueOf(degrees);
        this.degrees = degrees;
    }

    @Override
    public String getFriendlyName() {
        return this.displayName;
    }

    public int getDegrees() {
        return this.degrees;
    }

    public static Rotation getRotation(int degrees) {
        int actualRotation = degrees % 360;
        for (Rotation rotation : Rotation.values()) {
            if (rotation.getDegrees() != actualRotation) continue;
            return rotation;
        }
        return DEGREES_0;
    }

    public Rotation addRotation(Rotation rotation) {
        return Rotation.getRotation(this.getDegrees() + rotation.getDegrees());
    }

    public Rotation rotateClockwise() {
        return Rotation.getRotation((this.degrees + 90) % 360);
    }

    public Rotation rotateAnticlockwise() {
        return Rotation.getRotation((this.degrees + 270) % 360);
    }
}

