/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.transition;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.commons.util.RequireUtils;
import org.sejda.model.pdf.transition.PdfPageTransitionStyle;

public final class PdfPageTransition {
    @NotNull
    private PdfPageTransitionStyle style;
    @Min(value=1L)
    private @Min(value=1L) int transitionDuration;
    @Min(value=1L)
    private @Min(value=1L) int displayDuration;

    private PdfPageTransition(PdfPageTransitionStyle style, int transitionDuration, int displayDuration) {
        this.style = style;
        this.transitionDuration = transitionDuration;
        this.displayDuration = displayDuration;
    }

    public PdfPageTransitionStyle getStyle() {
        return this.style;
    }

    public int getTransitionDuration() {
        return this.transitionDuration;
    }

    public int getDisplayDuration() {
        return this.displayDuration;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.style).append("transitionDuration", this.transitionDuration).append("displayDuration", this.displayDuration).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.style).append(this.transitionDuration).append(this.displayDuration).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PdfPageTransition)) {
            return false;
        }
        PdfPageTransition transition = (PdfPageTransition)other;
        return new EqualsBuilder().append((Object)this.style, (Object)transition.getStyle()).append(this.transitionDuration, transition.getTransitionDuration()).append(this.displayDuration, transition.getDisplayDuration()).isEquals();
    }

    public static PdfPageTransition newInstance(PdfPageTransitionStyle style, int transitionDuration, int displayDuration) {
        RequireUtils.requireArg((displayDuration > 0 ? 1 : 0) != 0, (String)"Input display duration must be positive");
        RequireUtils.requireArg((transitionDuration > 0 ? 1 : 0) != 0, (String)"Input transition duration must be positive");
        RequireUtils.requireNotNullArg((Object)style, (String)"Input style cannot be null");
        return new PdfPageTransition(style, transitionDuration, displayDuration);
    }
}

