/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.page;

import java.util.SortedSet;
import java.util.TreeSet;
import org.sejda.model.FriendlyNamed;
import org.sejda.model.pdf.page.PagesSelection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PredefinedSetOfPages implements PagesSelection,
FriendlyNamed
{
    ALL_PAGES("all"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            TreeSet<Integer> retSet = new TreeSet<Integer>();
            for (int i = 1; i <= totalNumberOfPage; ++i) {
                retSet.add(i);
            }
            return retSet;
        }

        @Override
        public boolean includes(int page) {
            return true;
        }
    }
    ,
    EVEN_PAGES("even"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            TreeSet<Integer> retSet = new TreeSet<Integer>();
            for (int i = 2; i <= totalNumberOfPage; i += 2) {
                retSet.add(i);
            }
            return retSet;
        }

        @Override
        public boolean includes(int page) {
            return page % 2 == 0;
        }
    }
    ,
    ODD_PAGES("odd"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            TreeSet<Integer> retSet = new TreeSet<Integer>();
            for (int i = 1; i <= totalNumberOfPage; i += 2) {
                retSet.add(i);
            }
            return retSet;
        }

        @Override
        public boolean includes(int page) {
            return page % 2 == 1;
        }
    }
    ,
    NONE("none"){

        @Override
        public SortedSet<Integer> getPages(int totalNumberOfPage) {
            return new TreeSet<Integer>();
        }

        @Override
        public boolean includes(int page) {
            return false;
        }
    };

    private final String displayName;

    public abstract SortedSet<Integer> getPages(int var1);

    public abstract boolean includes(int var1);

    private PredefinedSetOfPages(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getFriendlyName() {
        return this.displayName;
    }
}

