/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.headerfooter;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.pdf.headerfooter.NumberingStyle;

public class Numbering {
    public static final Numbering NULL = new Numbering(NumberingStyle.EMPTY, 1);
    @NotNull
    private NumberingStyle numberingStyle;
    @Min(value=1L)
    private @Min(value=1L) int logicalPageNumber;

    public Numbering(NumberingStyle numberingStyle, int logicalPageNumber) {
        if (numberingStyle == null) {
            throw new IllegalArgumentException("Input numbering style cannot be null.");
        }
        this.numberingStyle = numberingStyle;
        this.logicalPageNumber = logicalPageNumber;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.numberingStyle).append(this.logicalPageNumber).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Numbering other = (Numbering)obj;
        return new EqualsBuilder().append((Object)this.numberingStyle, (Object)other.numberingStyle).append(this.logicalPageNumber, other.logicalPageNumber).isEquals();
    }

    public NumberingStyle getNumberingStyle() {
        return this.numberingStyle;
    }

    public int getLogicalPageNumber() {
        return this.logicalPageNumber;
    }

    public String styledLabelFor(int pageNumber) {
        return this.numberingStyle.toStyledString(pageNumber).trim();
    }
}

