/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.commons.collection.NullSafeSet;
import org.sejda.model.parameter.AbstractSplitByPageParameters;

public class SplitByPagesParameters
extends AbstractSplitByPageParameters {
    @NotEmpty
    private final Set<Integer> pages = new NullSafeSet();

    public void addPages(Collection<Integer> pagesToAdd) {
        this.pages.addAll(pagesToAdd);
    }

    public void addPage(Integer page) {
        this.pages.add(page);
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        return this.pages.stream().filter(p -> p <= upperLimit && p > 0).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(this.pages).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.pages).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplitByPagesParameters)) {
            return false;
        }
        SplitByPagesParameters parameter = (SplitByPagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.pages, parameter.pages).isEquals();
    }
}

