/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.commons.collection.NullSafeSet;
import org.sejda.model.optimization.OptimizationPolicy;
import org.sejda.model.parameter.base.DiscardableOutlineTaskParameters;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.parameter.base.OptimizableOutputTaskParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.validation.constraint.HasSelectedPages;
import org.sejda.model.validation.constraint.NotAllowed;

@HasSelectedPages
public class ExtractPagesParameters
extends MultiplePdfSourceMultipleOutputParameters
implements PagesSelection,
OptimizableOutputTaskParameters,
DiscardableOutlineTaskParameters {
    @NotNull
    private OptimizationPolicy optimizationPolicy = OptimizationPolicy.NO;
    private boolean discardOutline = false;
    @NotNull
    @NotAllowed(disallow={PredefinedSetOfPages.ALL_PAGES})
    private final PredefinedSetOfPages predefinedSetOfPages;
    @Valid
    private final Set<PagesSelection> pageSelection = new NullSafeSet();
    private boolean invertSelection = false;
    private boolean separateFileForEachRange = false;

    public ExtractPagesParameters() {
        this.predefinedSetOfPages = PredefinedSetOfPages.NONE;
    }

    public ExtractPagesParameters(PredefinedSetOfPages predefinedSetOfPages) {
        this.predefinedSetOfPages = Optional.ofNullable(predefinedSetOfPages).orElse(PredefinedSetOfPages.NONE);
    }

    public void addPageRange(PagesSelection range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    public PredefinedSetOfPages getPredefinedSetOfPages() {
        return this.predefinedSetOfPages;
    }

    public boolean hasPageSelection() {
        return !this.pageSelection.isEmpty();
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        Object pages = new NullSafeSet();
        if (this.predefinedSetOfPages != PredefinedSetOfPages.NONE) {
            pages = this.predefinedSetOfPages.getPages(upperLimit);
        } else {
            for (PagesSelection range : this.pageSelection) {
                pages.addAll(range.getPages(upperLimit));
            }
        }
        if (!this.invertSelection) {
            return pages;
        }
        NullSafeSet invertedPages = new NullSafeSet();
        for (int i = 1; i <= upperLimit; ++i) {
            if (pages.contains(i)) continue;
            invertedPages.add(i);
        }
        return invertedPages;
    }

    public List<Set<Integer>> getPagesSets(int upperLimit) {
        ArrayList<Set<Integer>> pages = new ArrayList<Set<Integer>>();
        if (this.predefinedSetOfPages == PredefinedSetOfPages.NONE && this.isSeparateFileForEachRange()) {
            if (this.invertSelection) {
                NullSafeSet currentRange = new NullSafeSet();
                int previous = 0;
                for (int current : this.getPages(upperLimit)) {
                    if (currentRange.isEmpty() || current == previous + 1) {
                        currentRange.add(current);
                        previous = current;
                        continue;
                    }
                    pages.add((Set<Integer>)currentRange);
                    currentRange = new NullSafeSet();
                    currentRange.add(current);
                    previous = current;
                }
                if (!currentRange.isEmpty()) {
                    pages.add((Set<Integer>)currentRange);
                }
            } else {
                for (PagesSelection range : this.pageSelection) {
                    pages.add(range.getPages(upperLimit));
                }
            }
            return pages;
        }
        return Collections.singletonList(this.getPages(upperLimit));
    }

    @Override
    public OptimizationPolicy getOptimizationPolicy() {
        return this.optimizationPolicy;
    }

    @Override
    public void setOptimizationPolicy(OptimizationPolicy optimizationPolicy) {
        this.optimizationPolicy = optimizationPolicy;
    }

    @Override
    public boolean discardOutline() {
        return this.discardOutline;
    }

    @Override
    public void discardOutline(boolean discardOutline) {
        this.discardOutline = discardOutline;
    }

    public boolean isInvertSelection() {
        return this.invertSelection;
    }

    public void setInvertSelection(boolean invertSelection) {
        this.invertSelection = invertSelection;
    }

    public boolean isSeparateFileForEachRange() {
        return this.separateFileForEachRange;
    }

    public void setSeparateFileForEachRange(boolean separateFileForEachRange) {
        this.separateFileForEachRange = separateFileForEachRange;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.optimizationPolicy).append(this.discardOutline).append((Object)this.predefinedSetOfPages).append(this.invertSelection).append(this.separateFileForEachRange).append(this.pageSelection).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtractPagesParameters)) {
            return false;
        }
        ExtractPagesParameters parameter = (ExtractPagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.predefinedSetOfPages, (Object)parameter.predefinedSetOfPages).append((Object)this.optimizationPolicy, (Object)parameter.optimizationPolicy).append(this.discardOutline, parameter.discardOutline).append(this.pageSelection, parameter.pageSelection).append(this.invertSelection, parameter.invertSelection).append(this.separateFileForEachRange, parameter.separateFileForEachRange).isEquals();
    }
}

