/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.output;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.AbstractTaskOutput;
import org.sejda.model.output.MultipleTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;

public class DirectoryTaskOutput
extends AbstractTaskOutput
implements MultipleTaskOutput {
    private final File directory;

    public DirectoryTaskOutput(File directory) {
        if (Objects.isNull(directory) || directory.exists() && !directory.isDirectory()) {
            throw new IllegalArgumentException("A not null directory instance is expected. Path: " + String.valueOf(directory));
        }
        this.directory = directory;
    }

    @Override
    public File getDestination() {
        return this.directory;
    }

    @Override
    public void accept(TaskOutputDispatcher writer) throws TaskOutputVisitException {
        try {
            writer.dispatch(this);
        }
        catch (IOException e) {
            throw new TaskOutputVisitException("Exception dispatching the file task output.", e);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append((Object)this.directory).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.directory).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DirectoryTaskOutput)) {
            return false;
        }
        DirectoryTaskOutput output = (DirectoryTaskOutput)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.directory, (Object)output.getDestination()).isEquals();
    }
}

