/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.model.encryption.NoEncryptionAtRest;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.AbstractPdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.validation.constraint.PdfFile;

public class PdfFileSource
extends AbstractPdfSource<File> {
    @PdfFile
    private final File file;

    private PdfFileSource(File file, String password) {
        super(file.getName(), password);
        this.file = file;
    }

    @Override
    public File getSource() {
        return this.file;
    }

    @Override
    public <T> T open(PdfSourceOpener<T> opener) throws TaskIOException {
        return opener.open(this);
    }

    @Override
    SeekableSource initializeSeekableSource() throws IOException {
        if (this.getEncryptionAtRestPolicy() instanceof NoEncryptionAtRest) {
            return SeekableSources.seekableSourceFrom((File)this.file);
        }
        return SeekableSources.onTempFileSeekableSourceFrom((InputStream)this.getEncryptionAtRestPolicy().decrypt(new FileInputStream(this.file)), (String)this.file.getName());
    }

    public static PdfFileSource newInstanceNoPassword(File file) {
        return PdfFileSource.newInstanceWithPassword(file, null);
    }

    public static PdfFileSource newInstanceWithPassword(File file, String password) {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("A not null File instance that isFile is expected. Path: " + String.valueOf(file));
        }
        return new PdfFileSource(file, password);
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }
}

