/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.commons.util.NumericalSortFilenameComparator;
import org.sejda.conversion.AbstractPdfInputFilesSource;

class FolderFileSourceListParser
extends AbstractPdfInputFilesSource {
    protected static final String PDF_EXTENSION = "pdf";
    private Pattern pattern;

    FolderFileSourceListParser(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    protected List<String> parseFileNames(File file) {
        return Arrays.stream(file.listFiles((dir, filename) -> StringUtils.equalsIgnoreCase((CharSequence)FilenameUtils.getExtension((String)filename), (CharSequence)PDF_EXTENSION) && this.pattern.matcher(filename).matches())).sorted((Comparator<File>)new NumericalSortFilenameComparator()).map(File::getAbsolutePath).collect(Collectors.toList());
    }
}

