/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sejda.conversion.AbstractPdfInputFilesSource;
import org.sejda.conversion.exception.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvFileSourceListParser
extends AbstractPdfInputFilesSource {
    private static final Logger LOG = LoggerFactory.getLogger(CsvFileSourceListParser.class);

    CsvFileSourceListParser() {
    }

    @Override
    protected List<String> parseFileNames(File file) {
        try {
            return this.doParseFileNames(file);
        }
        catch (Exception e) {
            LOG.error("Can't extract filenames", (Throwable)e);
            throw new ConversionException("Can't extract filenames from '" + file.getName() + "'. Reason:" + e.getMessage(), e);
        }
    }

    protected List<String> doParseFileNames(File file) throws IOException {
        return Files.readAllLines(file.toPath(), Charset.defaultCharset()).stream().map(line -> line.split(",")).flatMap(Arrays::stream).collect(Collectors.toList());
    }
}

