/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.theme;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.ColorScheme;
import javafx.application.Platform;
import org.pdfsam.theme.Theme;
import org.sejda.commons.util.RequireUtils;

public class Themes {
    private static final TreeMap<String, Theme> THEMES = ServiceLoader.load(Theme.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(Theme::id, Function.identity(), (a, b) -> a, TreeMap::new));

    public static Theme getOrDefault(String id) {
        return Optional.ofNullable(Themes.get(id)).orElseGet(Themes::defaultTheme);
    }

    public static Theme get(String id) {
        if (Objects.nonNull(id)) {
            return THEMES.get(id);
        }
        return null;
    }

    private static Theme defaultTheme() {
        RequireUtils.require((!THEMES.isEmpty() ? 1 : 0) != 0, () -> new IllegalStateException("No theme available"));
        ColorScheme colorScheme = Platform.getPreferences().getColorScheme();
        for (Theme theme : THEMES.values()) {
            if (!theme.isDefault() || !Themes.isSameScheme(theme, colorScheme)) continue;
            return theme;
        }
        return THEMES.get(THEMES.firstKey());
    }

    private static boolean isSameScheme(Theme theme, ColorScheme colorScheme) {
        return theme.isDark() == (ColorScheme.DARK == colorScheme);
    }

    public static SortedMap<String, Theme> themes() {
        return Collections.unmodifiableSortedMap(THEMES);
    }
}

