/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.io;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Objects;
import javafx.application.HostServices;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.io.NativeOpenUrlRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class NativeOpenUrlController {
    private static final Logger LOG = LoggerFactory.getLogger(NativeOpenUrlController.class);
    private final HostServices services;

    @Inject
    public NativeOpenUrlController(HostServices services) {
        this.services = services;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void openUrl(NativeOpenUrlRequest event) {
        if (Objects.nonNull(event.url()) && !event.url().isBlank()) {
            try {
                this.services.showDocument(event.url());
            }
            catch (NullPointerException npe) {
                this.fallbackOpen(event);
            }
        }
    }

    private void fallbackOpen(NativeOpenUrlRequest event) {
        LOG.info("Unable to open url using HostServices, trying fallback");
        try {
            Runtime.getRuntime().exec(NativeOpenUrlController.getOpenCmd(event.url()));
        }
        catch (IOException e) {
            LOG.warn("Unable to open '" + event.url() + "', please copy and paste the url to your browser", (Throwable)e);
        }
    }

    private static String getOpenCmd(String url) throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return String.format("%s %s", "open", url);
        }
        if (os.contains("win")) {
            return String.format("%s %s", "explorer", url);
        }
        if (os.contains("nix") || os.contains("nux") || os.indexOf("aix") > 0) {
            return String.format("%s %s", "xdg-open", url);
        }
        throw new IOException("Unable to identify the open command for the OS " + os);
    }
}

