/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.inject.Named;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.ui.StageStatus;
import org.pdfsam.persistence.DefaultEntityRepository;
import org.pdfsam.persistence.PreferencesRepository;
import org.pdfsam.service.tool.ToolUsage;

public class PersistenceConfig {
    @Provides
    public ObjectMapper jsonMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule())).enable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS})).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).serializationInclusion(JsonInclude.Include.NON_EMPTY)).build();
    }

    @Provides
    @Named(value="stageStatusRepository")
    DefaultEntityRepository<StageStatus> stageStatusRepository(ObjectMapper mapper) {
        return new DefaultEntityRepository("/org/pdfsam/stage", mapper, StageStatus.class);
    }

    @Provides
    @Named(value="recentWorkspacesRepository")
    PreferencesRepository recentWorkspacesRepository() {
        return new PreferencesRepository("/org/pdfsam/user/workspaces");
    }

    @Provides
    @Named(value="newsRepository")
    PreferencesRepository newsRepo() {
        return new PreferencesRepository("/org/pdfsam/user/news");
    }

    @Provides
    @Named(value="usageRepository")
    DefaultEntityRepository<ToolUsage> usageRepository(ObjectMapper mapper) {
        return new DefaultEntityRepository("/org/pdfsam/modules/usage", mapper, ToolUsage.class);
    }

    @Provides
    @Named(value="toolsOrderRepository")
    PreferencesRepository toolsOrderRepo() {
        return new PreferencesRepository("/org/pdfsam/tools/order");
    }
}

