/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.sidebar;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.sidebar.ToolSelectableSidebarButton;
import org.pdfsam.model.lifecycle.CleanupRequest;
import org.pdfsam.model.lifecycle.ShutdownEvent;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.persistence.PreferencesRepository;

public class ToolsButtons
extends VBox {
    private static final DataFormat DND_BUTTONS_MIME_TYPE = new DataFormat(new String[]{"application/x-java-tools-button"});
    private static final String TOOL_ORDER = "toolOrder";
    private final PreferencesRepository repo;
    private boolean orderChanged;
    private final Comparator<ToolSelectableSidebarButton> toolsComparator = Comparator.comparing(ToolSelectableSidebarButton::category).thenComparing(Labeled::getText);
    private final Comparator<ToolSelectableSidebarButton> toolsComparatorWithOrder = Comparator.comparing(ToolSelectableSidebarButton::order).thenComparing(this.toolsComparator);

    @Inject
    public ToolsButtons(@Named(value="toolsOrderRepository") PreferencesRepository repo) {
        this(repo, ApplicationContext.app().runtimeState().tools());
    }

    public ToolsButtons(PreferencesRepository repo, Map<String, Tool> tools) {
        this.getStyleClass().addAll((Object[])new String[]{"tools-buttons"});
        this.repo = repo;
        tools.values().stream().map(t -> ToolSelectableSidebarButton.of(t, repo.getInt("toolOrder_" + t.id(), -1))).sorted(this.toolsComparatorWithOrder).map(this::makeDraggable).forEach(arg_0 -> this.getChildren().add(arg_0));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private Node makeDraggable(Node node) {
        node.setOnDragDetected(e -> {
            Dragboard db = node.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            db.setDragView((Image)node.snapshot(null, null));
            ClipboardContent cc = new ClipboardContent();
            cc.put((Object)DND_BUTTONS_MIME_TYPE, (Object)this.getChildren().indexOf((Object)node));
            db.setContent((Map)cc);
            e.consume();
        });
        node.setOnDragOver(e -> {
            Integer index;
            Object patt0$temp = e.getDragboard().getContent(DND_BUTTONS_MIME_TYPE);
            if (patt0$temp instanceof Integer && (index = (Integer)patt0$temp).intValue() != this.getChildren().indexOf((Object)node)) {
                e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                e.consume();
            }
        });
        node.setOnDragEntered(e -> {
            Integer index;
            Object patt0$temp = e.getDragboard().getContent(DND_BUTTONS_MIME_TYPE);
            if (patt0$temp instanceof Integer && (index = (Integer)patt0$temp).intValue() != this.getChildren().indexOf((Object)node)) {
                node.getStyleClass().add((Object)"drag-over");
            }
        });
        node.setOnDragExited(e -> {
            Integer index;
            Object patt0$temp = e.getDragboard().getContent(DND_BUTTONS_MIME_TYPE);
            if (patt0$temp instanceof Integer && (index = (Integer)patt0$temp).intValue() != this.getChildren().indexOf((Object)node)) {
                node.getStyleClass().remove((Object)"drag-over");
            }
        });
        node.setOnDragDropped(e -> {
            Object patt0$temp = e.getDragboard().getContent(DND_BUTTONS_MIME_TYPE);
            if (patt0$temp instanceof Integer) {
                Integer index = (Integer)patt0$temp;
                int myIndex = this.getChildren().indexOf((Object)node);
                if (index != myIndex) {
                    node.getStyleClass().remove((Object)"drag-over");
                    Node dragged = (Node)this.getChildren().remove(index.intValue());
                    this.getChildren().add(this.getChildren().indexOf((Object)node), (Object)dragged);
                    this.orderChanged = true;
                    e.setDropCompleted(true);
                    e.consume();
                }
            }
        });
        return node;
    }

    @EventListener
    public void onShutdown(ShutdownEvent event) {
        if (this.orderChanged) {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Object object = this.getChildren().get(i);
                if (!(object instanceof ToolSelectableSidebarButton)) continue;
                ToolSelectableSidebarButton t = (ToolSelectableSidebarButton)object;
                this.repo.saveInt("toolOrder_" + t.id(), i);
            }
        }
    }

    @EventListener
    public void onCleanupRequest(CleanupRequest req) {
        this.repo.clean();
        List<ToolSelectableSidebarButton> sortedChildren = this.getChildren().stream().filter(n -> n instanceof ToolSelectableSidebarButton).map(n -> (ToolSelectableSidebarButton)n).sorted(this.toolsComparator).toList();
        this.getChildren().setAll(sortedChildren);
    }
}

