/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.sidebar;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import org.pdfsam.ui.components.support.Style;

class SidebarButton
extends Button {
    private final BooleanProperty displayText = new SimpleBooleanProperty(false){

        protected void invalidated() {
            if (this.get()) {
                SidebarButton.this.setContentDisplay(ContentDisplay.LEFT);
                SidebarButton.this.setAlignment(Pos.CENTER_LEFT);
            } else {
                SidebarButton.this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                SidebarButton.this.setAlignment(Pos.CENTER);
            }
        }
    };

    public SidebarButton() {
        this.getStyleClass().addAll((Object[])Style.SIDEBAR_BUTTON.css());
        this.setMaxWidth(Double.MAX_VALUE);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setAlignment(Pos.CENTER);
    }

    public SidebarButton(String text) {
        this();
        this.setText(text);
    }

    public SidebarButton(String text, Node graphic) {
        this(text);
        this.setGraphic(graphic);
    }

    public final BooleanProperty displayTextProperty() {
        return this.displayText;
    }

    public final void setDisplayText(boolean value) {
        this.displayTextProperty().set(value);
    }

    public final boolean isDisplayText() {
        return this.displayText.get();
    }
}

