/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.dnd;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.dialog.AddSubdirectoriesConfirmationDialog;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfFilesListLoadRequest;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.ui.dnd.FilesDroppedEvent;
import org.pdfsam.ui.components.notification.AddNotificationRequest;
import org.pdfsam.ui.components.notification.NotificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class FilesDropController {
    private static final Logger LOG = LoggerFactory.getLogger(FilesDropController.class);
    private final Provider<AddSubdirectoriesConfirmationDialog> dialog;

    @Inject
    public FilesDropController(Provider<AddSubdirectoriesConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void request(FilesDroppedEvent event) {
        if (event.acceptMultipleFiles()) {
            this.doRequestMultiple(event);
        } else {
            this.doRequestSingle(event);
        }
    }

    private void doRequestMultiple(FilesDroppedEvent event) {
        if (event.files().size() == 1 && !((File)event.files().get(0)).isDirectory() && (FileType.TXT.matches(((File)event.files().get(0)).getName()) || FileType.CSV.matches(((File)event.files().get(0)).getName()))) {
            Path path = ((File)event.files().get(0)).toPath();
            ApplicationContext.app().runtimeState().maybeWorkingPath(path);
            StaticStudio.eventStudio().broadcast((Object)new PdfFilesListLoadRequest(event.toolBinding(), path));
        } else {
            PdfLoadRequest loadEvent = new PdfLoadRequest(event.toolBinding());
            this.getFiles(event.files()).filter(f -> FileType.PDF.matches(f.getName())).map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequest)loadEvent).add(arg_0));
            if (!loadEvent.getDocuments().isEmpty()) {
                ApplicationContext.app().runtimeState().maybeWorkingPath(((PdfDocumentDescriptor)loadEvent.getDocuments().get(0)).getFileName());
                StaticStudio.eventStudio().broadcast((Object)loadEvent, event.toolBinding());
            } else {
                StaticStudio.eventStudio().broadcast((Object)new AddNotificationRequest(NotificationType.WARN, I18nContext.i18n().tr("Drag and drop PDF files or directories containing PDF files"), I18nContext.i18n().tr("No PDF found")));
            }
        }
    }

    private Stream<File> getFiles(List<File> files) {
        if (files.size() == 1 && files.get(0).isDirectory()) {
            try {
                if (Arrays.stream(files.get(0).listFiles()).anyMatch(File::isDirectory) && ((AddSubdirectoriesConfirmationDialog)((Object)this.dialog.get())).response()) {
                    return Files.walk(files.get(0).toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).sorted();
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to retrieve the list of files from " + String.valueOf(files.get(0)), (Throwable)e);
            }
            return Arrays.stream(files.get(0).listFiles()).sorted();
        }
        return files.stream();
    }

    public void doRequestSingle(FilesDroppedEvent event) {
        event.files().stream().filter(f -> FileType.PDF.matches(f.getName())).filter(File::isFile).map(PdfDocumentDescriptor::newDescriptorNoPassword).findFirst().ifPresent(file -> {
            PdfLoadRequest loadEvent = new PdfLoadRequest(event.toolBinding());
            loadEvent.add(file);
            StaticStudio.eventStudio().broadcast((Object)loadEvent, event.toolBinding());
        });
    }
}

