/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.dialog;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Objects;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.dialog.LenientExecutionConfirmationDialog;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.sejda.model.exception.TaskNonLenientExecutionException;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class LenientTaskExecutionDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(LenientTaskExecutionDialogController.class);
    private TaskExecutionRequest latest;
    private final Provider<LenientExecutionConfirmationDialog> dialog;

    @Inject
    public LenientTaskExecutionDialogController(Provider<LenientExecutionConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener(priority=-2147483647)
    public void request(TaskExecutionRequest event) {
        this.latest = event;
    }

    @EventListener(priority=0x7FFFFFFF)
    public void failed(TaskExecutionFailedEvent event) {
        if (event.getFailingCause() instanceof TaskNonLenientExecutionException && Objects.nonNull(this.latest) && ((LenientExecutionConfirmationDialog)((Object)this.dialog.get())).response()) {
            this.latest.parameters().setLenient(true);
            StaticStudio.eventStudio().broadcast((Object)this.latest);
            LOG.info("Re-executing task in lenient mode");
        }
    }
}

