/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.workspace;

import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.Optional;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.pdfsam.core.io.Choosers;
import org.pdfsam.core.io.FileChooserWithWorkingDirectory;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.content.workspace.WorkspaceMenuItem;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.ui.workspace.LoadWorkspaceRequest;
import org.pdfsam.model.ui.workspace.SaveWorkspaceRequest;
import org.pdfsam.model.ui.workspace.WorkspaceLoadedEvent;
import org.pdfsam.service.ui.RecentWorkspacesService;

public class WorkspaceMenu
extends ContextMenu {
    private final RecentWorkspacesService service;
    private final Menu recent;
    private Optional<Path> latestWorkspace = Optional.empty();

    @Inject
    public WorkspaceMenu(RecentWorkspacesService service) {
        this.service = service;
        this.setId("workspaceMenu");
        MenuItem load = new MenuItem(I18nContext.i18n().tr("_Load"));
        load.setId("loadWorkspace");
        load.setOnAction(e -> this.loadWorkspace());
        MenuItem save = new MenuItem(I18nContext.i18n().tr("_Save"));
        save.setOnAction(e -> this.saveWorkspace());
        save.setId("saveWorkspace");
        this.recent = new Menu(I18nContext.i18n().tr("Recen_ts"));
        this.recent.setId("recentWorkspace");
        service.getRecentlyUsedWorkspaces().stream().map(WorkspaceMenuItem::new).forEach(arg_0 -> this.recent.getItems().add(arg_0));
        MenuItem clear = new MenuItem(I18nContext.i18n().tr("_Clear recents"));
        clear.setOnAction(e -> this.clearWorkspaces());
        clear.setId("clearWorkspaces");
        this.getItems().addAll((Object[])new MenuItem[]{load, save, new SeparatorMenuItem(), this.recent, clear});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public void saveWorkspace() {
        FileChooserWithWorkingDirectory fileChooser = Choosers.fileChooser((String)I18nContext.i18n().tr("Select the workspace file to save"), (FileType[])new FileType[]{FileType.JSON});
        this.latestWorkspace.ifPresentOrElse(f -> {
            fileChooser.setInitialDirectory(f.getParent());
            fileChooser.setInitialFileName(f.getFileName().toString());
        }, () -> fileChooser.setInitialFileName("PDFsam_workspace.json"));
        Optional.ofNullable(fileChooser.showSaveDialog(null)).ifPresent(p -> {
            this.latestWorkspace = Optional.of(p);
            StaticStudio.eventStudio().broadcast((Object)new SaveWorkspaceRequest(p.toFile()));
        });
    }

    public void loadWorkspace() {
        FileChooserWithWorkingDirectory fileChooser = Choosers.fileChooser((String)I18nContext.i18n().tr("Select the workspace to load"), (FileType[])new FileType[]{FileType.JSON});
        this.latestWorkspace.ifPresent(f -> {
            fileChooser.setInitialDirectory(f.getParent());
            fileChooser.setInitialFileName(f.getFileName().toString());
        });
        Optional.ofNullable(fileChooser.showOpenSingleDialog(null)).ifPresent(p -> StaticStudio.eventStudio().broadcast((Object)new LoadWorkspaceRequest(p.toFile())));
    }

    public void clearWorkspaces() {
        this.service.clear();
        this.recent.getItems().clear();
    }

    @EventListener
    public void onWorkspaceLoaded(WorkspaceLoadedEvent e) {
        this.recent.getItems().clear();
        this.service.getRecentlyUsedWorkspaces().stream().map(WorkspaceMenuItem::new).forEach(arg_0 -> this.recent.getItems().add(arg_0));
        this.latestWorkspace = Optional.of(e.workspace().toPath());
    }
}

