/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import jakarta.inject.Inject;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.pdfsam.gui.components.content.preference.PreferenceAppearencePane;
import org.pdfsam.gui.components.content.preference.PreferenceBehaviorPane;
import org.pdfsam.gui.components.content.preference.PreferenceOutputPane;
import org.pdfsam.gui.components.content.preference.PreferenceWorkspacePane;
import org.pdfsam.i18n.I18nContext;

public class PreferencePane
extends HBox {
    @Inject
    public PreferencePane(PreferenceAppearencePane appearance, PreferenceBehaviorPane behavior, PreferenceWorkspacePane workspace, PreferenceOutputPane output) {
        this.getStyleClass().add((Object)"spaced-container");
        VBox left = new VBox(5.0);
        left.setMinWidth(Double.NEGATIVE_INFINITY);
        this.addSectionTitle(I18nContext.i18n().tr("Appearance"), (Pane)left);
        left.getChildren().add((Object)appearance);
        this.addSectionTitle(I18nContext.i18n().tr("Behavior"), (Pane)left);
        left.getChildren().add((Object)behavior);
        VBox right = new VBox(5.0);
        HBox.setHgrow((Node)right, (Priority)Priority.ALWAYS);
        this.addSectionTitle(I18nContext.i18n().tr("Workspace"), (Pane)right);
        right.getChildren().add((Object)workspace);
        this.addSectionTitle(I18nContext.i18n().tr("Output"), (Pane)right);
        right.getChildren().add((Object)output);
        this.getChildren().addAll((Object[])new Node[]{left, right});
    }

    private void addSectionTitle(String title, Pane pane) {
        Label label = new Label(title);
        label.getStyleClass().add((Object)"section-title");
        pane.getChildren().add((Object)label);
    }
}

