/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.IntegerPersistentProperty;
import org.pdfsam.core.support.validation.Validator;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferenceIntTextField
extends ValidableTextField {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceIntTextField.class);

    PreferenceIntTextField(IntegerPersistentProperty property, Validator<String> validator) {
        this(property, ApplicationContext.app(), validator);
    }

    PreferenceIntTextField(IntegerPersistentProperty preference, ApplicationContext context, Validator<String> validator) {
        this.setValidator(validator);
        this.setEnableInvalidStyle(true);
        this.setOnEnterValidation(true);
        this.validProperty().addListener((o, oldVal, newVal) -> {
            if (newVal == FXValidationSupport.ValidationState.VALID) {
                context.persistentSettings().set(preference, Integer.parseInt(this.getText()));
                LOG.trace("Preference {} set to {}", (Object)preference, (Object)this.getText());
            }
        });
    }
}

