/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javafx.scene.Node;
import javafx.util.Subscription;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.core.context.IntegerPersistentProperty;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.core.support.validation.Validator;
import org.pdfsam.core.support.validation.Validators;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.components.content.log.MaxLogRowsChangedEvent;
import org.pdfsam.gui.components.content.preference.PreferenceBrowsableDirectoryField;
import org.pdfsam.gui.components.content.preference.PreferenceBrowsableFileField;
import org.pdfsam.gui.components.content.preference.PreferenceCheckBox;
import org.pdfsam.gui.components.content.preference.PreferenceComboBox;
import org.pdfsam.gui.components.content.preference.PreferenceIntTextField;
import org.pdfsam.gui.components.content.preference.PreferencePrefixField;
import org.pdfsam.gui.components.content.preference.PreferenceRadioButton;
import org.pdfsam.gui.theme.Themes;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.io.OpenType;
import org.pdfsam.model.ui.ComboItem;
import org.pdfsam.model.ui.DefaultPdfVersionComboItem;
import org.pdfsam.theme.Theme;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.model.pdf.PdfVersion;

public class PreferenceConfig {
    @Provides
    @Named(value="localeCombo")
    public PreferenceComboBox<ComboItem<String>> localeCombo() {
        return new PreferenceComboBox<ComboItem<String>>(StringPersistentProperty.LOCALE);
    }

    @Provides
    @Named(value="startupToolCombo")
    public PreferenceComboBox<ComboItem<String>> startupToolCombo() {
        PreferenceComboBox<ComboItem<String>> startupToolCombo = new PreferenceComboBox<ComboItem<String>>(StringPersistentProperty.STARTUP_MODULE);
        startupToolCombo.setId("startupModuleCombo");
        startupToolCombo.getItems().add((Object)new ComboItem((Object)"", I18nContext.i18n().tr("Home")));
        ApplicationContext.app().runtimeState().tools().values().stream().map(tool -> new ComboItem((Object)tool.id(), tool.descriptor().name())).sorted(Comparator.comparing(ComboItem::description)).forEach(arg_0 -> startupToolCombo.getItems().add(arg_0));
        startupToolCombo.setValue(ComboItem.keyWithEmptyValue((Object)ApplicationContext.app().persistentSettings().get(StringPersistentProperty.STARTUP_MODULE).orElse("")));
        return startupToolCombo;
    }

    @Provides
    @Named(value="themeCombo")
    public PreferenceComboBox<ComboItem<String>> themeCombo() {
        Subscription[] subscription;
        PreferenceComboBox<ComboItem<String>> themeCombo = new PreferenceComboBox<ComboItem<String>>(StringPersistentProperty.THEME);
        themeCombo.setId("themeCombo");
        Themes.themes().entrySet().stream().sorted(Comparator.comparing(e -> ((Theme)e.getValue()).name())).map(entry -> new ComboItem((Object)((String)entry.getKey()), ((Theme)entry.getValue()).name())).forEach(arg_0 -> themeCombo.getItems().add(arg_0));
        subscription = new Subscription[]{ApplicationContext.app().runtimeState().theme().subscribe(t -> {
            if (Objects.nonNull(t)) {
                themeCombo.setValue(new ComboItem((Object)t.id(), t.name()));
                themeCombo.valueProperty().addListener((observable, oldVal, newVal) -> Optional.ofNullable(Themes.get((String)newVal.key())).ifPresent(theme -> ApplicationContext.app().runtimeState().theme(theme)));
                Optional.ofNullable(subscription[0]).ifPresent(Subscription::unsubscribe);
            }
        })};
        return themeCombo;
    }

    @Provides
    @Named(value="fontSizeCombo")
    public PreferenceComboBox<ComboItem<String>> fontSizeCombo() {
        PreferenceComboBox<ComboItem<String>> fontSizeCombo = new PreferenceComboBox<ComboItem<String>>(StringPersistentProperty.FONT_SIZE);
        fontSizeCombo.setId("fontSizeCombo");
        fontSizeCombo.getItems().add((Object)new ComboItem((Object)"", I18nContext.i18n().tr("System default")));
        IntStream.range(9, 37).forEach(i -> fontSizeCombo.getItems().add((Object)new ComboItem((Object)(i + "px"), i + "px")));
        fontSizeCombo.setValue(ComboItem.keyWithEmptyValue((Object)ApplicationContext.app().persistentSettings().get(StringPersistentProperty.FONT_SIZE).orElse("")));
        return fontSizeCombo;
    }

    @Provides
    @Named(value="pdfVersionCombo")
    public PreferenceComboBox<ComboItem<PdfVersion>> pdfVersionCombo() {
        PreferenceComboBox<ComboItem<PdfVersion>> pdfVersionCombo = new PreferenceComboBox<ComboItem<PdfVersion>>(StringPersistentProperty.PDF_VERSION);
        pdfVersionCombo.setId("pdfVersionCombo");
        pdfVersionCombo.getItems().addAll(Arrays.stream(PdfVersion.values()).filter(v -> v.getVersion() > PdfVersion.VERSION_1_2.getVersion()).map(DefaultPdfVersionComboItem::new).toList());
        ApplicationContext.app().persistentSettings().get(StringPersistentProperty.PDF_VERSION).map(PdfVersion::valueOf).flatMap(v -> pdfVersionCombo.getItems().stream().filter(i -> i.key() == v).findFirst()).ifPresent(i -> pdfVersionCombo.getSelectionModel().select(i));
        return pdfVersionCombo;
    }

    @Provides
    @Named(value="checkForUpdates")
    public PreferenceCheckBox checkForUpdates() {
        PreferenceCheckBox checkForUpdates = new PreferenceCheckBox(BooleanPersistentProperty.CHECK_UPDATES, I18nContext.i18n().tr("Check for updates at startup"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.CHECK_UPDATES));
        checkForUpdates.setId("checkForUpdates");
        checkForUpdates.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether new version availability should be checked on startup (restart needed)")));
        checkForUpdates.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        checkForUpdates.getStyleClass().addAll((Object[])Style.VITEM.css());
        return checkForUpdates;
    }

    @Provides
    @Named(value="checkForNews")
    public PreferenceCheckBox checkForNews() {
        PreferenceCheckBox checkForNews = new PreferenceCheckBox(BooleanPersistentProperty.CHECK_FOR_NEWS, I18nContext.i18n().tr("Check for news at startup"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.CHECK_FOR_NEWS));
        checkForNews.setId("checkForNews");
        checkForNews.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether the application should check for news availability on startup (restart needed)")));
        checkForNews.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        checkForNews.getStyleClass().addAll((Object[])Style.VITEM.css());
        return checkForNews;
    }

    @Provides
    @Named(value="compressionEnabled")
    public PreferenceCheckBox compressionEnabled() {
        PreferenceCheckBox compressionEnabled = new PreferenceCheckBox(BooleanPersistentProperty.PDF_COMPRESSION_ENABLED, I18nContext.i18n().tr("Enabled PDF compression"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.PDF_COMPRESSION_ENABLED));
        compressionEnabled.setId("compressionEnabled");
        compressionEnabled.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether \"Compress output file\" should be enabled by default")));
        compressionEnabled.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        compressionEnabled.getStyleClass().addAll((Object[])Style.VITEM.css());
        return compressionEnabled;
    }

    @Provides
    @Named(value="discardBookmarks")
    public PreferenceCheckBox discardBookmarks() {
        PreferenceCheckBox discardBookmarks = new PreferenceCheckBox(BooleanPersistentProperty.DISCARD_BOOKMARKS, I18nContext.i18n().tr("Discard bookmarks"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.DISCARD_BOOKMARKS));
        discardBookmarks.setId("discardBookmarks");
        discardBookmarks.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether \"Discard bookmarks\" should be enabled by default")));
        discardBookmarks.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        discardBookmarks.getStyleClass().addAll((Object[])Style.VITEM.css());
        return discardBookmarks;
    }

    @Provides
    @Named(value="prefixField")
    public PreferencePrefixField prefixField() {
        return new PreferencePrefixField();
    }

    @Provides
    @Named(value="overwriteOutput")
    public PreferenceCheckBox overwriteOutput() {
        PreferenceCheckBox overwriteOutput = new PreferenceCheckBox(BooleanPersistentProperty.OVERWRITE_OUTPUT, I18nContext.i18n().tr("Overwrite files"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.OVERWRITE_OUTPUT));
        overwriteOutput.setId("overwriteOutput");
        overwriteOutput.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether \"Overwrite if already exists\" should be enabled by default")));
        overwriteOutput.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        overwriteOutput.getStyleClass().addAll((Object[])Style.VITEM.css());
        return overwriteOutput;
    }

    @Provides
    @Named(value="playSounds")
    public PreferenceCheckBox playSounds() {
        PreferenceCheckBox playSounds = new PreferenceCheckBox(BooleanPersistentProperty.PLAY_SOUNDS, I18nContext.i18n().tr("Play alert sounds"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.PLAY_SOUNDS));
        playSounds.setId("playSounds");
        playSounds.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Turn on or off alert sounds")));
        playSounds.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        playSounds.getStyleClass().addAll((Object[])Style.VITEM.css());
        return playSounds;
    }

    @Provides
    @Named(value="savePwdInWorkspace")
    public PreferenceCheckBox savePwdInWorkspace() {
        PreferenceCheckBox savePwdInWorkspace = new PreferenceCheckBox(BooleanPersistentProperty.SAVE_PWD_IN_WORKSPACE, I18nContext.i18n().tr("Store passwords when saving a workspace file"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.SAVE_PWD_IN_WORKSPACE));
        savePwdInWorkspace.setId("savePwdInWorkspace");
        savePwdInWorkspace.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("If an encrypted PDF document has been opened with a password, save the password in the workspace file")));
        savePwdInWorkspace.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        savePwdInWorkspace.getStyleClass().addAll((Object[])Style.VITEM.css());
        return savePwdInWorkspace;
    }

    @Provides
    @Named(value="donationNotification")
    public PreferenceCheckBox donationNotification() {
        PreferenceCheckBox donationNotification = new PreferenceCheckBox(BooleanPersistentProperty.DONATION_NOTIFICATION, I18nContext.i18n().tr("Show donation window"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.DONATION_NOTIFICATION));
        donationNotification.setId("donationNotification");
        donationNotification.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Turn on or off the notification appearing once in a while and asking the user to support PDFsam with a donation")));
        donationNotification.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        donationNotification.getStyleClass().addAll((Object[])Style.VITEM.css());
        return donationNotification;
    }

    @Provides
    @Named(value="fetchPremiumModules")
    public PreferenceCheckBox fetchPremiumModules() {
        PreferenceCheckBox fetchPremiumModules = new PreferenceCheckBox(BooleanPersistentProperty.PREMIUM_MODULES, I18nContext.i18n().tr("Show premium features"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.PREMIUM_MODULES));
        fetchPremiumModules.setId("fetchPremiumModules");
        fetchPremiumModules.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether the application should fetch and show premium features description in the modules dashboard")));
        fetchPremiumModules.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        fetchPremiumModules.getStyleClass().addAll((Object[])Style.VITEM.css());
        return fetchPremiumModules;
    }

    @Provides
    @Named(value="clearConfirmation")
    public PreferenceCheckBox clearConfirmation() {
        PreferenceCheckBox clearConfirmation = new PreferenceCheckBox(BooleanPersistentProperty.CLEAR_CONFIRMATION, I18nContext.i18n().tr("Ask for a confirmation when clearing the selection table"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.CLEAR_CONFIRMATION));
        clearConfirmation.setId("clearConfirmation");
        clearConfirmation.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether the application should ask for a confirmation when clearing the selection table")));
        clearConfirmation.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        clearConfirmation.getStyleClass().addAll((Object[])Style.VITEM.css());
        return clearConfirmation;
    }

    @Provides
    @Named(value="smartRadio")
    public PreferenceRadioButton smartRadio() {
        PreferenceRadioButton smartRadio = new PreferenceRadioButton(BooleanPersistentProperty.SMART_OUTPUT, I18nContext.i18n().tr("Use the selected PDF document directory as output directory"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.SMART_OUTPUT));
        smartRadio.setId("smartRadio");
        return smartRadio;
    }

    @Provides
    @Named(value="workingDirectory")
    public PreferenceBrowsableDirectoryField workingDirectory() {
        PreferenceBrowsableDirectoryField workingDirectory = new PreferenceBrowsableDirectoryField(StringPersistentProperty.WORKING_PATH);
        workingDirectory.getTextField().setText(ApplicationContext.app().persistentSettings().get(StringPersistentProperty.WORKING_PATH).orElse(""));
        workingDirectory.setId("workingDirectory");
        return workingDirectory;
    }

    @Provides
    @Named(value="workspace")
    public PreferenceBrowsableFileField workspace() {
        PreferenceBrowsableFileField workspace = new PreferenceBrowsableFileField(StringPersistentProperty.WORKSPACE_PATH, FileType.JSON, OpenType.OPEN);
        workspace.getTextField().setText(ApplicationContext.app().persistentSettings().get(StringPersistentProperty.WORKSPACE_PATH).orElse(""));
        workspace.setId("workspace");
        return workspace;
    }

    @Provides
    @Named(value="saveWorkspaceOnExit")
    public PreferenceCheckBox saveWorkspaceOnExit() {
        PreferenceCheckBox saveWorkspaceOnExit = new PreferenceCheckBox(BooleanPersistentProperty.SAVE_WORKSPACE_ON_EXIT, I18nContext.i18n().tr("Save default workspace on exit"), ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.SAVE_WORKSPACE_ON_EXIT));
        saveWorkspaceOnExit.setId("saveWorkspaceOnExit");
        saveWorkspaceOnExit.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("If a default workspace is set, save it on application exit")));
        saveWorkspaceOnExit.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        saveWorkspaceOnExit.getStyleClass().add((Object)"spaced-vitem");
        return saveWorkspaceOnExit;
    }

    @Provides
    @Named(value="logViewRowsNumber")
    public PreferenceIntTextField logViewRowsNumber() {
        PreferenceIntTextField logRowsNumber = new PreferenceIntTextField(IntegerPersistentProperty.LOGVIEW_ROWS_NUMBER, (Validator<String>)Validators.positiveInteger());
        logRowsNumber.setText(Integer.toString(ApplicationContext.app().persistentSettings().get(IntegerPersistentProperty.LOGVIEW_ROWS_NUMBER)));
        logRowsNumber.setErrorMessage(I18nContext.i18n().tr("Maximum number of rows mast be a positive number"));
        logRowsNumber.setId("logViewRowsNumber");
        logRowsNumber.validProperty().addListener((o, oldVal, newVal) -> {
            if (newVal == FXValidationSupport.ValidationState.VALID) {
                StaticStudio.eventStudio().broadcast((Object)new MaxLogRowsChangedEvent());
            }
        });
        return logRowsNumber;
    }
}

