/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import javafx.scene.control.CheckBox;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferenceCheckBox
extends CheckBox {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceCheckBox.class);

    PreferenceCheckBox(BooleanPersistentProperty property, String label, boolean selected) {
        this(property, label, selected, ApplicationContext.app());
    }

    PreferenceCheckBox(BooleanPersistentProperty property, String label, boolean selected, ApplicationContext context) {
        super(label);
        RequireUtils.requireNotNullArg((Object)property, (String)"Preference cannot be null");
        this.setSelected(selected);
        this.selectedProperty().addListener((ov, oldVal, newVal) -> {
            context.persistentSettings().set(property, newVal.booleanValue());
            LOG.trace("Preference {} set to {}", (Object)property, newVal);
        });
    }
}

