/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Comparator;
import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.components.content.preference.PreferenceComboBox;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.i18n.SetLocaleRequest;
import org.pdfsam.model.ui.ComboItem;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;

class PreferenceAppearencePane
extends GridPane {
    @Inject
    public PreferenceAppearencePane(@Named(value="localeCombo") PreferenceComboBox<ComboItem<String>> localeCombo, @Named(value="startupToolCombo") PreferenceComboBox<ComboItem<String>> startupTool, @Named(value="themeCombo") PreferenceComboBox<ComboItem<String>> themeCombo, @Named(value="fontSizeCombo") PreferenceComboBox<ComboItem<String>> fontSizeCombo) {
        this.add((Node)new Label(I18nContext.i18n().tr("Language:")), 0, 0);
        I18nContext.i18n().getSupported().stream().map(ComboItem::fromLocale).sorted(Comparator.comparing(ComboItem::description)).forEach(arg_0 -> localeCombo.getItems().add(arg_0));
        localeCombo.setValue(ComboItem.fromLocale((Locale)Locale.getDefault()));
        localeCombo.valueProperty().addListener((observable, oldValue, newValue) -> StaticStudio.eventStudio().broadcast((Object)new SetLocaleRequest((String)newValue.key())));
        localeCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(localeCombo, (Boolean)true);
        this.add((Node)localeCombo, 1, 0);
        this.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set your preferred language (restart needed)")), 2, 0);
        this.add((Node)new Label(I18nContext.i18n().tr("Startup tool:")), 0, 1);
        startupTool.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(startupTool, (Boolean)true);
        this.add((Node)startupTool, 1, 1);
        this.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set the tool to open at application startup (restart needed)")), 2, 1);
        this.add((Node)new Label(I18nContext.i18n().tr("Theme:")), 0, 2);
        themeCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(themeCombo, (Boolean)true);
        this.add((Node)themeCombo, 1, 2);
        this.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set the application theme")), 2, 2);
        this.add((Node)new Label(I18nContext.i18n().tr("Font size:")), 0, 3);
        fontSizeCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(fontSizeCombo, (Boolean)true);
        this.add((Node)fontSizeCombo, 1, 3);
        this.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set the application font size")), 2, 3);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.GRID.css());
    }
}

