/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.log;

import jakarta.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.stage.Window;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.IntegerPersistentProperty;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.content.log.LogLevel;
import org.pdfsam.gui.components.content.log.LogMessage;
import org.pdfsam.gui.components.content.log.MaxLogRowsChangedEvent;
import org.pdfsam.ui.components.support.CircularObservableList;

class LogListView
extends ListView<LogMessage> {
    @Inject
    public LogListView() {
        CircularObservableList items = new CircularObservableList(ApplicationContext.app().persistentSettings().get(IntegerPersistentProperty.LOGVIEW_ROWS_NUMBER));
        StaticStudio.eventStudio().add(MaxLogRowsChangedEvent.class, e -> items.setMaxCapacity(ApplicationContext.app().persistentSettings().get(IntegerPersistentProperty.LOGVIEW_ROWS_NUMBER)));
        this.setId("log-view");
        this.setItems((ObservableList)items);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setCellFactory(list -> new TextCell());
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onEvent(LogMessage event) {
        Platform.runLater(() -> {
            this.getItems().add((Object)event);
            this.scrollToBottomIfShowing();
        });
    }

    public void scrollToBottomIfShowing() {
        if (!this.getItems().isEmpty() && Optional.ofNullable(this.getScene()).map(Scene::getWindow).map(Window::isShowing).orElse(Boolean.TRUE).booleanValue()) {
            this.scrollTo(this.getItems().size() - 1);
        }
    }

    static class TextCell
    extends ListCell<LogMessage> {
        TextCell() {
        }

        public void updateItem(LogMessage item, boolean empty) {
            super.updateItem((Object)item, empty);
            for (LogLevel current : LogLevel.values()) {
                this.getStyleClass().remove((Object)current.style());
            }
            if (Objects.nonNull(item)) {
                this.setText(item.message());
                this.getStyleClass().add((Object)item.level().style());
            } else {
                this.setText("");
            }
        }
    }
}

