/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.home;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.components.content.home.HomeTile;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.model.ui.dnd.FilesDroppedEvent;
import org.pdfsam.ui.components.commons.UrlButton;

class ToolsHomeTile
extends HomeTile {
    private final String id;

    ToolsHomeTile(Tool tool) {
        super(tool.descriptor().name(), tool.descriptor().description(), tool.graphic(), tool.descriptor().category().styleClass());
        this.id = tool.id();
        this.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest(this.id))));
        Optional.ofNullable(tool.descriptor().supportUrl()).ifPresent(url -> {
            UrlButton helpButton = UrlButton.urlButton(null, (String)url, null, (String[])new String[]{"btn", "home-tools-help-button"});
            helpButton.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.QUESTION_CIRCLE, (int)18));
            this.addBottomPanel((Region)helpButton);
        });
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped(files -> new FilesDroppedEvent(this.id, tool.descriptor().hasInputType(ToolInputOutputType.MULTIPLE_PDF), files))));
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragDropped(Function<List<File>, ?> provider) {
        return e -> {
            StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest(this.id));
            StaticStudio.eventStudio().broadcast(provider.apply(e.getDragboard().getFiles()));
            e.setDropCompleted(true);
        };
    }
}

